/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.config;

import com.opensr5.ConfigurationImage;
import com.rusefi.config.Field;
import com.rusefi.config.FieldCommandResponse;
import com.rusefi.config.FieldType;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Pair;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.config.BaseConfigField;
import com.rusefi.ui.config.UnexpectedEnumOridnalException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;

public class EnumConfigField
extends BaseConfigField {
    private final JComboBox<String> view = new JComboBox();
    private boolean ec;
    private final Map<String, Integer> ordinals = new HashMap<String, Integer>();
    private final String[] options = this.field.getOptions();

    public EnumConfigField(UIContext uiContext, final Field field, String caption) {
        super(uiContext, field);
        if (this.options == null) {
            throw new NullPointerException("options for " + field);
        }
        this.createUi(caption, this.view);
        int ordinal = 0;
        for (String option : this.options) {
            this.ordinals.put(option, ordinal++);
            if ("invalid".equalsIgnoreCase(option)) continue;
            this.view.addItem(option);
        }
        this.requestInitialValue(field);
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                Pair<Integer, ?> p;
                if (FieldCommandResponse.isIntValueMessage(message) && (p = FieldCommandResponse.parseResponse(message)) != null && ((Integer)p.first).intValue() == field.getOffset()) {
                    int ordinal = (Integer)p.second;
                    try {
                        EnumConfigField.this.setValue(ordinal);
                    }
                    catch (UnexpectedEnumOridnalException e) {
                        System.out.println("ERROR " + e);
                    }
                }
            }
        });
        this.view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EnumConfigField.this.ec) {
                    return;
                }
                String value = (String)EnumConfigField.this.view.getSelectedItem();
                if (value == null) {
                    throw new NullPointerException(field.getName());
                }
                int ordinal = (Integer)EnumConfigField.this.ordinals.get(value);
                EnumConfigField.this.sendValue(field, Integer.toString(ordinal));
            }
        });
    }

    private void setValue(int ordinal) throws UnexpectedEnumOridnalException {
        String item;
        if (ordinal >= this.options.length) {
            item = "unexpected_" + ordinal;
            this.view.addItem(item);
        } else {
            if (ordinal < 0 || ordinal >= this.options.length) {
                throw new UnexpectedEnumOridnalException(ordinal + " unexpected on " + this.field);
            }
            item = this.options[ordinal];
        }
        this.ec = true;
        this.view.setEnabled(true);
        this.view.setSelectedItem(item);
        this.onValueArrived();
        this.ec = false;
    }

    @Override
    protected void loadValue(ConfigurationImage ci) {
        int ordinal = this.field.getType() == FieldType.INT8 ? this.getByteBuffer(ci).get() : (this.field.getType() == FieldType.INT16 ? this.getByteBuffer(ci).getShort() : this.getByteBuffer(ci).getInt());
        try {
            this.setValue(ordinal);
        }
        catch (UnexpectedEnumOridnalException e) {
            log.error("Error loading value " + e);
        }
    }
}

