/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.VariableRegistry;
import com.rusefi.ldmp.LiveDataProcessor;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.PerFieldWithStructuresIterator;
import com.rusefi.parse.TypesHelper;
import com.rusefi.util.LazyFile;
import java.io.IOException;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataLogConsumer
implements ConfigurationConsumer {
    private static final int MSQ_LENGTH_LIMIT = 34;
    public static final String UNUSED = "unused";
    private final String fileName;
    private final LazyFile.LazyFileFactory fileFactory;
    private final StringBuilder tsWriter = new StringBuilder();
    private final TreeSet<String> comments = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    public String[] outputNames = new String[]{""};

    public DataLogConsumer(String fileName, LazyFile.LazyFileFactory fileFactory) {
        this.fileName = fileName;
        this.fileFactory = fileFactory;
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
        if (readerState.isStackEmpty()) {
            for (int i = 0; i < this.outputNames.length; ++i) {
                final String temporaryLineComment = LiveDataProcessor.needComment(i) ? ";" : "";
                final String outputNamePrefix = this.outputNames.length > 1 ? this.outputNames[i] : "";
                PerFieldWithStructuresIterator.Strategy strategy = new PerFieldWithStructuresIterator.Strategy(){

                    @Override
                    public String process(ReaderState state, ConfigField configField, String variableNamePrefixForEmptyComment, int currentPosition, PerFieldWithStructuresIterator perFieldWithStructuresIterator) {
                        return DataLogConsumer.this.handle(configField, variableNamePrefixForEmptyComment, temporaryLineComment, "", outputNamePrefix);
                    }

                    @Override
                    public boolean skip(ConfigField cf) {
                        return false;
                    }
                };
                PerFieldWithStructuresIterator iterator = new PerFieldWithStructuresIterator(readerState, structure.getTsFields(), "", strategy);
                iterator.loop(0);
                String content = iterator.getContent();
                this.tsWriter.append(content);
            }
        }
    }

    @Override
    public void endFile() throws IOException {
        this.writeStringToFile(this.fileName, this.tsWriter);
    }

    private void writeStringToFile(@Nullable String fileName, StringBuilder writer) throws IOException {
        if (fileName != null) {
            LazyFile fw = this.fileFactory.create(fileName);
            fw.write(writer.toString());
            fw.close();
        }
    }

    private String handle(ConfigField configField, String variableNamePrefixForEmptyComment, String temporaryLineComment, String variableNameSuffix, String outputNamePrefix) {
        if (configField.getName().contains(UNUSED)) {
            return "";
        }
        if (configField.isArray()) {
            return "";
        }
        String autoscaleSpec = configField.autoscaleSpec();
        String typeString = TypesHelper.isFloat(configField.getTypeName()) || autoscaleSpec != null && !autoscaleSpec.equals("1, 1") ? "float,  \"%.3f\"" : "int,    \"%d\"";
        String comment = DataLogConsumer.getHumanGaugeName(outputNamePrefix, variableNamePrefixForEmptyComment, configField, variableNameSuffix);
        if (this.comments.contains(comment)) {
            throw new IllegalStateException(comment + " already present in the outputs! " + configField);
        }
        this.comments.add(comment);
        return temporaryLineComment + "entry = " + variableNamePrefixForEmptyComment + configField.getName() + variableNameSuffix + ", " + comment + ", " + typeString + "\n";
    }

    @NotNull
    public static String getHumanGaugeName(String outputNamePrefix, String variableNamePrefixForEmptyComment, ConfigField configField, String variableNameSuffix) {
        String comment = configField.getCommentTemplated();
        if ((comment = DataLogConsumer.getFirstLine(comment)).isEmpty()) {
            comment = variableNamePrefixForEmptyComment + VariableRegistry.unquote(configField.getName());
        }
        if ((comment = outputNamePrefix + comment + variableNameSuffix).length() > 34) {
            throw new IllegalStateException("[" + comment + "] is too long for log files at " + comment.length() + " limit " + 34);
        }
        if (comment.charAt(0) != '\"') {
            comment = VariableRegistry.quote(comment);
        }
        return comment;
    }

    private static String getFirstLine(String comment) {
        String[] comments = comment == null ? new String[]{} : VariableRegistry.unquote(comment).split("\\\\n");
        comment = comments.length > 0 ? comments[0] : "";
        return comment;
    }

    public String getContent() {
        return this.tsWriter.toString();
    }
}

