/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.serial;

import com.devexperts.logging.Logging;
import com.rusefi.Callable;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.ConnectionStateListener;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkConnector;
import com.rusefi.io.LinkManager;
import com.rusefi.io.serial.PortHolder;

public class StreamConnector
implements LinkConnector {
    private static final Logging log = Logging.getLogging(StreamConnector.class);
    private final PortHolder portHolder;
    private final LinkManager linkManager;

    public StreamConnector(LinkManager linkManager, Callable<IoStream> ioStreamCallable) {
        this.linkManager = linkManager;
        this.portHolder = new PortHolder(linkManager, ioStreamCallable);
    }

    @Override
    public void connectAndReadConfiguration(BinaryProtocol.Arguments arguments, ConnectionStateListener listener) {
        log.info("StreamConnector: connecting");
        this.portHolder.listener = listener;
        log.info("scheduleOpening");
        this.linkManager.execute(() -> {
            log.info("scheduleOpening>openPort");
            this.portHolder.connectAndReadConfiguration(arguments);
        });
    }

    @Override
    public BinaryProtocol getBinaryProtocol() {
        return this.portHolder.getBp();
    }

    @Override
    public void stop() {
        this.portHolder.close();
    }

    @Override
    public String unpack(String packet) {
        return packet;
    }

    @Override
    public void send(String text, boolean fireEvent) throws InterruptedException {
        this.portHolder.packAndSend(text, fireEvent);
    }
}

