/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.can;

import com.devexperts.logging.Logging;
import com.opensr5.io.DataListener;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.io.can.PCanHelper;
import com.rusefi.io.can.isotp.IsoTpCanDecoder;
import com.rusefi.io.can.isotp.IsoTpConnector;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.io.serial.RateCounter;
import com.rusefi.io.tcp.BinaryProtocolServer;
import com.rusefi.ui.StatusConsumer;
import com.rusefi.util.HexBinary;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.Nullable;
import peak.can.basic.PCANBasic;
import peak.can.basic.TPCANMsg;
import peak.can.basic.TPCANStatus;

public class PCanIoStream
extends AbstractIoStream {
    private static final int INFO_SKIP_RATE = 3;
    static Logging log = Logging.getLogging(PCanIoStream.class);
    private final IncomingDataBuffer dataBuffer;
    private final PCANBasic can;
    private final StatusConsumer statusListener;
    private final RateCounter totalCounter = new RateCounter();
    private final RateCounter isoTpCounter = new RateCounter();
    private final IsoTpCanDecoder canDecoder = new IsoTpCanDecoder(){

        @Override
        protected void onTpFirstFrame() {
            PCanIoStream.this.sendCanPacket(1.FLOW_CONTROL);
        }
    };
    private final IsoTpConnector isoTpConnector = new IsoTpConnector(1808){

        @Override
        public void sendCanData(byte[] total) {
            PCanIoStream.this.sendCanPacket(total);
        }
    };
    private int logSkipRate;

    @Nullable
    public static PCanIoStream createStream() {
        return PCanIoStream.createStream((message, breakLineOnTextArea, sendToLogger) -> {
            if (sendToLogger) {
                log.info(message);
            }
        });
    }

    public static PCanIoStream createStream(StatusConsumer statusListener) {
        PCANBasic can = PCanHelper.create();
        TPCANStatus status = PCanHelper.init(can);
        if (status != TPCANStatus.PCAN_ERROR_OK) {
            statusListener.appendStatus("Error initializing PCAN: " + (Object)((Object)status));
            return null;
        }
        statusListener.appendStatus("Creating PCAN stream...");
        return new PCanIoStream(can, statusListener);
    }

    private void sendCanPacket(byte[] payLoad) {
        TPCANStatus status;
        if (log.debugEnabled()) {
            log.debug("-------sendIsoTp " + payLoad.length + " byte(s):");
        }
        if (log.debugEnabled()) {
            log.debug("Sending " + HexBinary.printHexBinary(payLoad));
        }
        if ((status = PCanHelper.send(this.can, this.isoTpConnector.canId(), payLoad)) != TPCANStatus.PCAN_ERROR_OK) {
            this.statusListener.appendStatus("Unable to write the CAN message: " + (Object)((Object)status));
            System.exit(0);
        }
    }

    private PCanIoStream(PCANBasic can, StatusConsumer statusListener) {
        this.can = can;
        this.statusListener = statusListener;
        this.dataBuffer = this.createDataBuffer();
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        IsoTpConnector.sendStrategy(bytes, this.isoTpConnector);
    }

    @Override
    public void setInputListener(DataListener listener) {
        ExecutorService threadExecutor = Executors.newSingleThreadExecutor(BinaryProtocolServer.getThreadFactory("PCAN reader"));
        threadExecutor.execute(() -> {
            while (!this.isClosed()) {
                this.readOnePacket(listener);
            }
        });
    }

    private void readOnePacket(DataListener listener) {
        TPCANMsg rx = new TPCANMsg(127);
        TPCANStatus status = this.can.Read(PCanHelper.CHANNEL, rx, null);
        if (status == TPCANStatus.PCAN_ERROR_OK) {
            this.totalCounter.add();
            if (rx.getID() != 1824) {
                ++this.logSkipRate;
                if (this.logSkipRate % 3 == 0) {
                    PCanHelper.debugPacket(rx);
                    log.info("Skipping non " + String.format("%X", 1824) + " packet: " + String.format("%X", rx.getID()));
                    log.info("Total rate " + this.totalCounter.getCurrentRate() + ", isotp rate " + this.isoTpCounter.getCurrentRate());
                }
                return;
            }
            PCanHelper.debugPacket(rx);
            this.isoTpCounter.add();
            byte[] decode = this.canDecoder.decodePacket(rx.getData());
            listener.onDataArrived(decode);
        }
    }

    @Override
    public IncomingDataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public String toString() {
        return "PCanIoStream{" + (Object)((Object)PCanHelper.CHANNEL) + ", totalCounter=" + this.totalCounter + '}';
    }
}

