/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.tcp;

import com.devexperts.logging.Logging;
import com.rusefi.CompatibleFunction;
import com.rusefi.Listener;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.core.FileUtil;
import com.rusefi.io.IoStream;
import com.rusefi.io.tcp.BinaryProtocolServer;
import com.rusefi.io.tcp.ServerSocketReference;
import com.rusefi.io.tcp.TcpIoStream;
import com.rusefi.ui.StatusConsumer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public class BinaryProtocolProxy {
    private static final Logging log = Logging.getLogging(BinaryProtocolProxy.class);
    public static final int USER_IO_TIMEOUT = 600000;

    public static ServerSocketReference createProxy(IoStream targetEcuSocket, int serverProxyPort, ClientApplicationActivityListener clientApplicationActivityListener, StatusConsumer statusConsumer) throws IOException {
        CompatibleFunction<Socket, Runnable> clientSocketRunnableFactory = clientSocket -> () -> {
            TcpIoStream clientStream = null;
            try {
                clientStream = new TcpIoStream("[[proxy]] ", (Socket)clientSocket);
                BinaryProtocolProxy.runProxy(targetEcuSocket, clientStream, clientApplicationActivityListener, 600000);
            }
            catch (IOException e) {
                statusConsumer.appendStatus("ERROR BinaryProtocolProxy::run " + e);
                FileUtil.close(clientStream);
            }
        };
        return BinaryProtocolServer.tcpServerSocket(serverProxyPort, "proxy", clientSocketRunnableFactory, Listener.empty(), statusConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runProxy(IoStream targetEcu, IoStream clientStream, ClientApplicationActivityListener listener, int timeoutMs) throws IOException {
        while (!targetEcu.isClosed()) {
            BinaryProtocolServer.Packet controllerResponse;
            byte firstByte = clientStream.getDataBuffer().readByte(timeoutMs);
            if (firstByte == 70) {
                log.info("Responding to GET_PROTOCOL_VERSION with 001");
                clientStream.write("001".getBytes());
                clientStream.flush();
                continue;
            }
            BinaryProtocolServer.Packet clientRequest = BinaryProtocolProxy.readClientRequest(clientStream.getDataBuffer(), firstByte);
            byte[] packet = clientRequest.getPacket();
            if (packet.length > 1 && packet[0] == 122 && packet[1] == 14) {
                throw new IOException("User requested disconnect");
            }
            listener.onActivity(clientRequest);
            IoStream ioStream = targetEcu;
            synchronized (ioStream) {
                BinaryProtocolProxy.sendToTarget(targetEcu, clientRequest);
                controllerResponse = targetEcu.readPacket();
            }
            if (log.debugEnabled()) {
                log.debug("Relaying controller response length=" + controllerResponse.getPacket().length);
            }
            clientStream.sendPacket(controllerResponse);
        }
    }

    @NotNull
    private static BinaryProtocolServer.Packet readClientRequest(IncomingDataBuffer in, byte firstByte) throws IOException {
        byte secondByte = in.readByte();
        int length = IoHelper.getInt(firstByte, secondByte);
        return BinaryProtocolServer.readPromisedBytes(in, length);
    }

    private static void sendToTarget(IoStream targetOutputStream, BinaryProtocolServer.Packet packet) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.getPacket()));
        byte command = (byte)dis.read();
        if (log.debugEnabled()) {
            log.debug("Relaying client command " + BinaryProtocol.findCommand(command));
        }
        targetOutputStream.sendPacket(packet);
    }

    public static interface ClientApplicationActivityListener {
        public static final ClientApplicationActivityListener VOID = clientRequest -> {};

        public void onActivity(BinaryProtocolServer.Packet var1);
    }
}

