/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImageMetaVersion0_0;
import com.opensr5.ConfigurationImageWithMeta;
import com.opensr5.ini.IniFileModel;
import com.rusefi.SerialPortScanner;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.BinaryProtocolExecutor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Optional;

public class CalibrationsBackuper {
    private static final Logging log = Logging.getLogging(CalibrationsBackuper.class);
    private static final String PREVIOUS_CALIBRATIONS_INI = "prev_calibrations.ini";
    private static final String PREVIOUS_CALIBRATIONS_BINARY = "prev_calibrations.zip";
    private static final String PREVIOUS_CALIBRATIONS_XML = "prev_calibrations.msq";

    private static Optional<CalibrationsMeta> readMeta(BinaryProtocol binaryProtocol, UpdateOperationCallbacks callbacks) {
        try {
            String signature = BinaryProtocol.getSignature(binaryProtocol.getStream());
            callbacks.logLine(String.format("Received a signature %s", signature));
            IniFileModel iniFile = BinaryProtocol.iniFileProvider.provide(signature);
            int pageSize = iniFile.getMetaInfo().getTotalSize();
            callbacks.logLine(String.format("Page size is %d", pageSize));
            return Optional.of(new CalibrationsMeta(iniFile.getIniFilePath(), new ConfigurationImageMetaVersion0_0(pageSize, signature)));
        }
        catch (IOException e) {
            log.error("Failed to read meta:", e);
            callbacks.logLine("Failed to read meta");
            return Optional.empty();
        }
    }

    public static boolean backUpCurrentCalibrations(SerialPortScanner.PortResult ecuPort, UpdateOperationCallbacks callbacks) {
        return BinaryProtocolExecutor.executeWithSuspendedPortScanner(ecuPort.port, callbacks, binaryProtocol -> {
            try {
                Optional<CalibrationsMeta> meta = CalibrationsBackuper.readMeta(binaryProtocol, callbacks);
                if (meta.isPresent()) {
                    CalibrationsMeta receivedMeta = meta.get();
                    callbacks.logLine("Reading current calibrations...");
                    ConfigurationImageWithMeta image = binaryProtocol.readFullImageFromController(receivedMeta.meta);
                    Path iniFilePath = Paths.get(receivedMeta.iniFilePath, new String[0]);
                    callbacks.logLine(String.format("Backing up current file %s...", iniFilePath));
                    Files.copy(iniFilePath, Paths.get(PREVIOUS_CALIBRATIONS_INI, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    callbacks.logLine(String.format("%s file is backed up", iniFilePath.getFileName()));
                    callbacks.logLine("Save current calibrations to files...");
                    binaryProtocol.saveConfigurationImageToFiles(image, PREVIOUS_CALIBRATIONS_BINARY, PREVIOUS_CALIBRATIONS_XML);
                    callbacks.logLine("Current calibrations are backed up to files");
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                log.error("Back up current calibrations failed:", e);
                callbacks.logLine("Back up current calibrations failed");
                return false;
            }
        });
    }

    private static class CalibrationsMeta {
        private final String iniFilePath;
        private final ConfigurationImageMetaVersion0_0 meta;

        CalibrationsMeta(String iniFilePath, ConfigurationImageMetaVersion0_0 meta) {
            this.iniFilePath = iniFilePath;
            this.meta = meta;
        }
    }
}

