/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.AvailableHardware;
import com.rusefi.SerialPortScanner;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.ui.BasicLogoHelper;
import com.rusefi.ui.basic.BasicUpdaterPanel;
import com.rusefi.ui.util.DefaultExceptionHandler;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.StatusPanel;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BasicStartupFrame {
    private final String whiteLabel = ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties());
    private final boolean doNotUseStatusWindow = true;
    private final StatusPanel statusPanel = new StatusPanel();
    private final BasicUpdaterPanel basicUpdaterPanel = new BasicUpdaterPanel(ConnectionAndMeta.isDefaultWhitelabel(this.whiteLabel), this.statusPanel, true);
    private final FrameHelper frame = FrameHelper.createFrame(this.whiteLabel + " basic console " + 20250206);
    private final StatusAnimation status = new StatusAnimation(this::updateStatus, "Scanning ports");

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        BasicStartupFrame.runTool(null);
    }

    public static void runTool(String[] args) throws InterruptedException, InvocationTargetException {
        DefaultExceptionHandler.install();
        SwingUtilities.invokeAndWait(BasicStartupFrame::new);
    }

    public BasicStartupFrame() {
        JPanel panel = new JPanel();
        panel.add(this.basicUpdaterPanel);
        panel.add(this.statusPanel);
        SerialPortScanner.INSTANCE.addListener(currentHardware -> SwingUtilities.invokeLater(() -> this.onHardwareUpdated(currentHardware)));
        BasicLogoHelper.setGenericFrameIcon(this.frame.getFrame());
        this.frame.showFrame(panel, false);
        UiUtils.centerWindow(this.frame.getFrame());
        this.packFrame();
    }

    private void packFrame() {
        this.frame.getFrame().pack();
    }

    private void updateStatus(String niceStatus) {
        this.basicUpdaterPanel.updateStatus(niceStatus);
        this.packFrame();
    }

    public void onHardwareUpdated(AvailableHardware currentHardware) {
        this.status.stop();
        this.basicUpdaterPanel.onHardwareUpdated(currentHardware);
        this.packFrame();
    }
}

