/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.AutotestLogging;
import com.rusefi.AverageAnglePanel;
import com.rusefi.BenchTestPane;
import com.rusefi.ConnectionTab;
import com.rusefi.FileLog;
import com.rusefi.Launcher;
import com.rusefi.SensorSnifferPane;
import com.rusefi.StartupFrame;
import com.rusefi.autodetect.PortDetector;
import com.rusefi.binaryprotocol.BinaryProtocolLogger;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.LinkManager;
import com.rusefi.io.serial.BaudRateHolder;
import com.rusefi.maintenance.StLinkFlasher;
import com.rusefi.ui.GaugesPanel;
import com.rusefi.ui.LiveDataPane;
import com.rusefi.ui.MessagesPane;
import com.rusefi.ui.SensorsLiveDataPane;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.console.MainFrame;
import com.rusefi.ui.console.TabbedPanel;
import com.rusefi.ui.engine.EngineSnifferPanel;
import com.rusefi.ui.lua.LuaScriptPanel;
import com.rusefi.ui.util.DefaultExceptionHandler;
import com.rusefi.ui.util.JustOneInstance;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.util.LazyFileImpl;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConsoleUI {
    private static final Logging log = Logging.getLogging(ConsoleUI.class);
    private static final int DEFAULT_TAB_INDEX = 0;
    private static final String WIKI_URL = "https://github.com/rusefi/rusefi/wiki/rusEFI-logs-folder";
    public static final String TAB_INDEX = "main_tab";
    protected static final String PORT_KEY = "port";
    protected static final String SPEED_KEY = "speed";
    public static EngineSnifferPanel engineSnifferPanel;
    static Frame staticFrame;
    private final TabbedPanel tabbedPane;
    private final String port;
    public final UIContext uiContext = new UIContext();
    private final Map<Component, ActionListener> tabSelectedListeners = new HashMap<Component, ActionListener>();

    public static Frame getFrame() {
        return staticFrame;
    }

    public ConsoleUI(String port) {
        int selectedIndex;
        CommandQueue.ERROR_HANDLER = e -> SwingUtilities.invokeLater(() -> {
            throw new IllegalStateException("Connectivity error", (Throwable)e);
        });
        log.info("init...");
        this.tabbedPane = new TabbedPanel(this.uiContext);
        this.port = port;
        MainFrame mainFrame = new MainFrame(this, this.tabbedPane);
        staticFrame = mainFrame.getFrame().getFrame();
        StartupFrame.setFrameIcon(staticFrame);
        log.info("Console 20250206");
        log.info("Hardware: " + (Object)((Object)StLinkFlasher.getHardwareKind()));
        PersistentConfiguration.getConfig().getRoot().setProperty(PORT_KEY, port);
        PersistentConfiguration.getConfig().getRoot().setProperty(SPEED_KEY, BaudRateHolder.INSTANCE.baudRate);
        LinkManager linkManager = this.uiContext.getLinkManager();
        linkManager.start(port, mainFrame.listener);
        engineSnifferPanel = new EngineSnifferPanel(this.uiContext, PersistentConfiguration.getConfig().getRoot().getChild("digital_sniffer"));
        if (!LinkManager.isLogViewerMode(port)) {
            engineSnifferPanel.setOutpinListener(this.uiContext.getLinkManager().getEngineState());
        }
        this.uiContext.DetachedRepositoryINSTANCE.init(PersistentConfiguration.getConfig().getRoot().getChild("detached"));
        this.uiContext.DetachedRepositoryINSTANCE.load();
        if (!linkManager.isLogViewer()) {
            this.tabbedPane.addTab("Gauges", new GaugesPanel(this.uiContext, PersistentConfiguration.getConfig().getRoot().getChild("gauges")).getContent());
        }
        if (!linkManager.isLogViewer()) {
            MessagesPane messagesPane = new MessagesPane(this.uiContext, PersistentConfiguration.getConfig().getRoot().getChild("messages"));
            this.tabbedPaneAdd("Messages", messagesPane.getContent(), messagesPane.getTabSelectedListener());
        }
        if (!linkManager.isLogViewer()) {
            this.tabbedPane.addTab("Bench Test", new BenchTestPane(this.uiContext, PersistentConfiguration.getConfig()).getContent());
        }
        if (!linkManager.isLogViewer()) {
            LuaScriptPanel luaScriptPanel = new LuaScriptPanel(this.uiContext, PersistentConfiguration.getConfig().getRoot().getChild("lua"));
            this.tabbedPaneAdd("Lua Scripting", luaScriptPanel.getPanel(), luaScriptPanel.getTabSelectedListener());
        }
        this.tabbedPaneAdd("Engine Sniffer", engineSnifferPanel.getPanel(), engineSnifferPanel.getTabSelectedListener());
        if (!linkManager.isLogViewer()) {
            SensorSnifferPane sensorSniffer = new SensorSnifferPane(this.uiContext, PersistentConfiguration.getConfig().getRoot().getChild("sensor_sniffer"));
            this.tabbedPaneAdd("Sensor Sniffer", sensorSniffer.getPanel(), sensorSniffer.getTabSelectedListener());
        }
        if (!linkManager.isLogViewer()) {
            this.tabbedPane.addTab("Live Data", LiveDataPane.createLazy(this.uiContext).getContent());
            this.tabbedPane.addTab("Sensors Live Data", new SensorsLiveDataPane(this.uiContext).getContent());
        }
        if (!linkManager.isLogViewer()) {
            // empty if block
        }
        if (!linkManager.isLogViewer() && this.tabbedPane.paneSettings.showTriggerShapePane) {
            this.tabbedPane.addTab("Trigger Shape", new AverageAnglePanel(this.uiContext).getPanel());
        }
        MessagesCentral.getInstance().postMessage(ConsoleUI.class, "COMPOSITE_OFF_RPM=" + BinaryProtocolLogger.COMPOSITE_OFF_RPM);
        this.tabbedPane.addTab("Connection", new ConnectionTab(this.uiContext).getContent());
        if (!LinkManager.isLogViewerMode(port) && (selectedIndex = PersistentConfiguration.getConfig().getRoot().getIntProperty(TAB_INDEX, 0)) < this.tabbedPane.tabbedPane.getTabCount()) {
            this.tabbedPane.tabbedPane.setSelectedIndex(selectedIndex);
        }
        this.tabbedPane.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    JTabbedPane pane = (JTabbedPane)e.getSource();
                    int selectedIndex = pane.getSelectedIndex();
                    System.out.println("Selected paneNo: " + selectedIndex);
                    ActionListener actionListener = (ActionListener)ConsoleUI.this.tabSelectedListeners.get(pane.getComponentAt(selectedIndex));
                    if (actionListener != null) {
                        actionListener.actionPerformed(null);
                    }
                }
            }
        });
        AutoupdateUtil.setAppIcon(mainFrame.getFrame().getFrame());
        log.info("showFrame");
        mainFrame.getFrame().showFrame(this.tabbedPane.tabbedPane);
    }

    public String getPort() {
        return this.port;
    }

    private static void writeReadmeFile() {
        LazyFileImpl file = new LazyFileImpl("logs/README.html");
        file.write("<center><a href='https://github.com/rusefi/rusefi/wiki/rusEFI-logs-folder'>More info online<br/><img src=https://raw.githubusercontent.com/wiki/rusefi/rusefi/logo.gif></a>");
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void startUi(String[] args) throws InterruptedException, InvocationTargetException {
        if (ConnectionAndMeta.saveReadmeHtmlToFile()) {
            new Thread(ConsoleUI::writeReadmeFile).start();
        }
        log.info("OS name: " + FileLog.getOsName());
        log.info("OS version: " + System.getProperty("os.version"));
        PersistentConfiguration.getConfig().load();
        AutotestLogging.suspendLogging = PersistentConfiguration.getConfig().getRoot().getBoolProperty("DISABLE_LOGS");
        DefaultExceptionHandler.install();
        SwingUtilities.invokeAndWait(() -> ConsoleUI.awtCode(args));
    }

    private void tabbedPaneAdd(String title, JComponent component, ActionListener tabSelectedListener) {
        this.tabSelectedListeners.put(component, tabSelectedListener);
        this.tabbedPane.addTab(title, component);
    }

    private static void awtCode(String[] args) {
        int result;
        if (JustOneInstance.isAlreadyRunning() && (result = JOptionPane.showConfirmDialog(UiUtils.createOnTopParent(), "Looks like another instance is already running. Do you really want to start another instance?", "rusEfi", 0)) == 1) {
            System.exit(-1);
        }
        JustOneInstance.onStart();
        try {
            boolean isBaudRateDefined;
            boolean isPortDefined = args.length > 0;
            boolean bl = isBaudRateDefined = args.length > 1;
            if (isBaudRateDefined) {
                BaudRateHolder.INSTANCE.baudRate = Integer.parseInt(args[1]);
            }
            String port = null;
            if (isPortDefined) {
                port = args[0];
            }
            if (isPortDefined && (port = PortDetector.autoDetectSerialIfNeeded(port)) == null) {
                isPortDefined = false;
            }
            if (isPortDefined) {
                new ConsoleUI(port);
            } else {
                for (String p : LinkManager.getCommPorts()) {
                    MessagesCentral.getInstance().postMessage(Launcher.class, "Available port: " + p);
                }
                new StartupFrame().showUi();
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }
}

