/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.engine;

import com.devexperts.logging.Logging;
import com.rusefi.FileLog;
import com.rusefi.config.generated.Fields;
import com.rusefi.core.EngineState;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ui.ChartRepository;
import com.rusefi.ui.ChartScrollControl;
import com.rusefi.ui.RpmLabel;
import com.rusefi.ui.RpmModel;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.WarningPanel;
import com.rusefi.ui.config.BitConfigField;
import com.rusefi.ui.config.ConfigUiField;
import com.rusefi.ui.engine.ChannelNaming;
import com.rusefi.ui.engine.EngineSnifferStatusPanel;
import com.rusefi.ui.engine.UpDownImage;
import com.rusefi.ui.engine.ZoomControl;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.AnyCommand;
import com.rusefi.waves.EngineChart;
import com.rusefi.waves.EngineChartParser;
import com.rusefi.waves.EngineReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class EngineSnifferPanel {
    private static final Logging log = Logging.getLogging(EngineSnifferPanel.class);
    private static final int EFI_DEFAULT_CHART_SIZE = 180;
    public static final Comparator<String> INSTANCE = new ImageOrderComparator();
    private static final String HELP_URL = "http://rusefi.com/wiki/index.php?title=Manual:DevConsole#Digital_Chart";
    public static final String HELP_TEXT = "Click here for online help";
    private final JPanel chartPanel = new JPanel(new BorderLayout());
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private final TreeMap<String, UpDownImage> images = new TreeMap(INSTANCE);
    private final JPanel imagePanel = new JPanel(new GridLayout(1, 1)){

        @Override
        public Dimension getPreferredSize() {
            Dimension d = EngineSnifferPanel.this.chartPanel.getSize();
            Dimension s = super.getPreferredSize();
            return new Dimension((int)((double)d.width * EngineSnifferPanel.this.zoomControl.getZoomProvider().getZoomValue()), s.height);
        }
    };
    private final ZoomControl zoomControl = new ZoomControl();
    private final EngineSnifferStatusPanel statusPanel = new EngineSnifferStatusPanel();
    private final UpDownImage crank = this.createImage("t1");
    private final ChartScrollControl scrollControl;
    private AnyCommand command;
    private boolean isPaused;

    public EngineSnifferPanel(UIContext uiContext, Node config) {
        this.statusPanel.setTimeAxisTranslator(this.crank.createTranslator());
        final JButton pauseButton = UiUtils.createPauseButton();
        pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineSnifferPanel.this.setPaused(pauseButton, !EngineSnifferPanel.this.isPaused);
            }
        });
        JButton clearButton = UiUtils.createClearButton();
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (UpDownImage image : EngineSnifferPanel.this.images.values()) {
                    image.setWaveReport(EngineReport.MOCK, null);
                }
                EngineSnifferPanel.this.setPaused(pauseButton, false);
            }
        });
        JButton saveImageButton = UiUtils.createSaveImageButton();
        saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineSnifferPanel.this.saveImage();
            }
        });
        JPanel upperPanel = new JPanel(new FlowLayout(0, 5, 0));
        upperPanel.add(clearButton);
        upperPanel.add(saveImageButton);
        upperPanel.add(pauseButton);
        upperPanel.add(new RpmLabel(uiContext, 2).getContent());
        if (!uiContext.getLinkManager().isLogViewer()) {
            this.command = AnyCommand.createField(uiContext, config, "chartsize 180", true, true);
            upperPanel.add(this.command.getContent());
        }
        upperPanel.add(this.zoomControl);
        this.scrollControl = ChartRepository.getInstance().createControls(chart -> this.displayChart(chart));
        if (uiContext.getLinkManager().isLogViewer()) {
            upperPanel.add(this.scrollControl.getContent());
        }
        upperPanel.add(new URLLabel(HELP_TEXT, HELP_URL));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        if (!uiContext.getLinkManager().isLogViewer()) {
            JPanel lowerButtons = new JPanel(new FlowLayout(2, 5, 0));
            lowerButtons.add(new ConfigUiField(uiContext, Fields.GLOBALTRIGGERANGLEOFFSET, "Trigger Offset").getContent());
            lowerButtons.add(new BitConfigField(uiContext, Fields.VERBOSETRIGGERSYNCHDETAILS, "Verbose trigger Sync").getContent());
            lowerButtons.add(new BitConfigField(uiContext, Fields.VERBOSEVVTDECODING, "Verbose VVT Sync").getContent());
            lowerButtons.add(new BitConfigField(uiContext, Fields.ENGINESNIFFERFOCUSONINPUTS, "Focus On Inputs").getContent());
            lowerButtons.add(new ConfigUiField(uiContext, Fields.ENGINECHARTSIZE, "Engine Sniffer size").getContent());
            lowerButtons.add(new ConfigUiField(uiContext, Fields.ENGINESNIFFERRPMTHRESHOLD, "RPM threshold").getContent());
            lowerButtons.add(new BitConfigField(uiContext, Fields.INVERTPRIMARYTRIGGERSIGNAL, "Invert Primary Input").getContent());
            bottomPanel.add((Component)lowerButtons, "North");
        }
        bottomPanel.add((Component)this.statusPanel.infoPanel, "South");
        this.chartPanel.add((Component)upperPanel, "North");
        JScrollPane pane = new JScrollPane(this.imagePanel, 21, 32);
        this.chartPanel.add((Component)pane, "Center");
        this.chartPanel.add((Component)bottomPanel, "South");
        this.zoomControl.listener = () -> {
            System.out.println("onZoomChange");
            AutoupdateUtil.trueLayout(this.imagePanel.getParent());
        };
        this.resetImagePanel();
        uiContext.getLinkManager().getEngineState().registerStringValueAction("wave_chart", new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String value) {
                if (EngineSnifferPanel.this.isPaused) {
                    return;
                }
                EngineSnifferPanel.this.displayChart(value);
            }
        });
        this.mainPanel.add((Component)this.chartPanel, "Center");
        this.mainPanel.add((Component)new WarningPanel(config).getPanel(config), "South");
    }

    private void setPaused(JButton pauseButton, boolean isPaused) {
        this.isPaused = isPaused;
        UiUtils.setPauseButtonText(pauseButton, this.isPaused);
    }

    public void setOutpinListener(EngineState engineState) {
        engineState.registerStringValueAction("outpin", new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String value) {
                String[] pinInfo = value.split("@");
                if (pinInfo.length != 2) {
                    return;
                }
                String channel = pinInfo[0];
                String pin = pinInfo[1];
                UpDownImage image = (UpDownImage)EngineSnifferPanel.this.images.get(channel);
                ChannelNaming.INSTANCE.channelName2PhysicalPin.put(channel, pin);
                if (image != null) {
                    image.setPhysicalPin(pin);
                }
            }
        });
    }

    private void resetImagePanel() {
        this.imagePanel.removeAll();
        this.imagePanel.add(this.crank);
        this.images.put("t1", this.crank);
    }

    public void displayChart(String value) {
        EngineChart map = EngineChartParser.unpackToMap(value);
        StringBuilder revolutions = map.get("r");
        this.statusPanel.setRevolutions(revolutions);
        for (String imageName : map.getMap().keySet()) {
            this.createSecondaryImage(imageName);
        }
        for (String imageName : this.images.keySet()) {
            UpDownImage image = this.images.get(imageName);
            if (image == null) {
                throw new IllegalStateException("image not found for " + imageName);
            }
            StringBuilder sb = map.getMap().get(imageName);
            String report = sb == null ? "" : sb.toString();
            image.setRevolutions(revolutions);
            List<EngineReport.UpDown> list = EngineReport.parse(report);
            EngineReport wr = new EngineReport(list);
            image.setWaveReport(wr, revolutions);
        }
        SwingUtilities.invokeLater(() -> AutoupdateUtil.trueLayout(this.imagePanel));
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    private void createSecondaryImage(String name) {
        if (this.images.containsKey(name)) {
            return;
        }
        if ("r".equalsIgnoreCase(name)) {
            return;
        }
        int index = EngineSnifferPanel.getInsertIndex(name, this.images.keySet());
        log.info("Engine sniffer register channel " + name + " at idx " + index);
        UpDownImage image = this.createImage(name);
        this.images.put(name, image);
        image.setTranslator(this.crank.createTranslator());
        this.imagePanel.add((Component)image, index);
        this.imagePanel.setLayout(new GridLayout(this.images.size(), 1));
    }

    public static int getInsertIndex(String name, Set<String> strings) {
        String[] mapKeys = new String[strings.size()];
        int pos = 0;
        for (String key : strings) {
            mapKeys[pos++] = key;
        }
        int index = -Arrays.binarySearch(mapKeys, 0, mapKeys.length, name, INSTANCE) - 1;
        if (index >= strings.size()) {
            index = -1;
        }
        return index;
    }

    private void saveImage() {
        int rpm = RpmModel.getInstance().getValue();
        double maf = SensorCentral.getInstance().getValue(Sensor.MAF);
        String fileName = FileLog.getDate() + "rpm_" + rpm + "_maf_" + maf + ".png";
        UiUtils.saveImageWithPrompt(fileName, this.mainPanel, this.imagePanel);
    }

    private UpDownImage createImage(final String name) {
        Color signalBody = Color.lightGray;
        Color signalBorder = Color.blue;
        if (name.startsWith("tach") || name.startsWith("dizzy")) {
            signalBody = Color.yellow;
        } else if (!name.startsWith("t")) {
            signalBody = name.startsWith("r") ? new Color(16753664) : (name.startsWith("c") ? Color.darkGray : (name.startsWith("i") || name.startsWith("j") ? Color.green : (name.startsWith("map") ? Color.pink : Color.gray)));
        }
        UpDownImage image = new UpDownImage(name, new UpDownImage.PinNameSource(){

            @Override
            public String getPinByName(String name) {
                return ChannelNaming.INSTANCE.channelName2PhysicalPin.get(name);
            }

            @Override
            public boolean isSimulationMode() {
                return false;
            }
        }){

            @Override
            protected boolean isShowTdcLabel() {
                return name.equals(EngineSnifferPanel.this.images.lastKey());
            }
        };
        image.setSignalBody(signalBody);
        image.setSignalBorder(signalBorder);
        image.addMouseMotionListener(this.statusPanel.motionAdapter);
        return image;
    }

    public void reloadFile() {
        this.displayChart(ChartRepository.getInstance().getChart(0));
        this.scrollControl.reset();
    }

    public ActionListener getTabSelectedListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EngineSnifferPanel.this.command != null) {
                    EngineSnifferPanel.this.command.requestFocus();
                }
            }
        };
    }

    static class ImageOrderComparator
    implements Comparator<String> {
        ImageOrderComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return this.fixNameForNicerOrder(o1).compareTo(this.fixNameForNicerOrder(o2));
        }

        String fixNameForNicerOrder(String s) {
            if (s.toLowerCase().startsWith("t")) {
                return "a" + s;
            }
            if (s.toLowerCase().startsWith("hip")) {
                return "z" + s;
            }
            if (s.toLowerCase().startsWith("spa")) {
                return "d" + s;
            }
            return s;
        }
    }
}

