/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini.field;

import com.opensr5.ConfigurationImage;
import com.opensr5.ini.field.IniField;
import com.rusefi.tune.xml.Constant;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class StringIniField
extends IniField {
    private final int size;

    public StringIniField(String name, int offset, int size) {
        super(name, offset);
        this.size = size;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getValue(ConfigurationImage image) {
        String value = new String(image.getContent(), this.getOffset(), this.size);
        value = value.trim();
        value = StringIniField.trimAtZeroSymbol(value);
        return value;
    }

    public String toString() {
        return "StringIniField{offset=" + this.getOffset() + ", size=" + this.size + '}';
    }

    @NotNull
    private static String trimAtZeroSymbol(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != '\u0000') continue;
            value = value.substring(0, i);
            break;
        }
        return value;
    }

    @Override
    public void setValue(ConfigurationImage image, Constant constant) {
        String value = constant.getValue();
        for (int i = 0; i < value.length(); ++i) {
            image.getContent()[this.getOffset() + i] = (byte)value.charAt(i);
        }
    }

    public static IniField parse(LinkedList<String> list) {
        String name = list.get(0);
        int offset = Integer.parseInt(list.get(3));
        if (!list.get(2).equalsIgnoreCase("ASCII")) {
            throw new IllegalStateException("Do not understand " + name + " at " + offset);
        }
        int size = Integer.parseInt(list.get(4));
        return new StringIniField(name, offset, size);
    }
}

