/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.util.UiUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.putgemin.VerticalFlowLayout;

abstract class CommandControl {
    public static final String TEST = "Test";
    public static final String SET = "Set";
    protected final JPanel panel = new JPanel(new FlowLayout(2, 5, 0));
    private final UIContext uiContext;

    public CommandControl(UIContext uiContext, String labelText, String iconFileName, String buttonText, JComponent ... components) {
        this.uiContext = uiContext;
        ImageIcon icon = AutoupdateUtil.loadIcon(iconFileName);
        JPanel rightVerticalPanel = new JPanel(new VerticalFlowLayout());
        rightVerticalPanel.add(new JLabel(labelText));
        for (JComponent component : components) {
            rightVerticalPanel.add(component);
        }
        JButton button = new JButton(buttonText);
        rightVerticalPanel.add(button);
        this.panel.add(new JLabel(icon));
        this.panel.add(rightVerticalPanel);
        int GAP = 3;
        this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(GAP, GAP, GAP, GAP)));
        button.addActionListener(this.createButtonListener());
    }

    @NotNull
    protected ActionListener createButtonListener() {
        return e -> this.uiContext.getCommandQueue().write(this.getCommand());
    }

    protected abstract String getCommand();

    public Component getContent() {
        return UiUtils.wrap(this.panel);
    }
}

