/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.preferences.storage;

import com.devexperts.logging.Logging;
import com.rusefi.core.FileUtil;
import com.rusefi.core.preferences.storage.Node;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;

public class PersistentConfiguration {
    private static final Logging log = Logging.getLogging(PersistentConfiguration.class);
    private static final PersistentConfiguration INSTANCE = new PersistentConfiguration();
    private static boolean hookRegistered;
    private static final String CONFIG_FILE_NAME;
    private Map<String, Object> config = new HashMap<String, Object>();
    private boolean isLoaded;

    public static PersistentConfiguration getConfig() {
        return INSTANCE;
    }

    private PersistentConfiguration() {
    }

    public static synchronized void registerShutdownHook() {
        if (hookRegistered) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Shutdown hook...");
            PersistentConfiguration.getConfig().save();
            log.info("Shutdown hook!");
        }));
        hookRegistered = true;
    }

    public static boolean getBoolProperty(String name) {
        return PersistentConfiguration.getConfig().getRoot().getBoolProperty(name);
    }

    public static void setBoolProperty(String name, boolean value) {
        PersistentConfiguration.getConfig().getRoot().setBoolProperty(name, value);
    }

    public void load() {
        if (!this.config.isEmpty()) {
            log.info("Configuration already loaded");
            return;
        }
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(CONFIG_FILE_NAME));
            XMLDecoder e = new XMLDecoder(inputStream, null, e1 -> {}, PersistentConfiguration.class.getClassLoader());
            this.config = (Map)e.readObject();
            e.close();
            log.info("Console configuration from " + CONFIG_FILE_NAME);
        }
        catch (Throwable e) {
            log.info("Console configuration not found " + CONFIG_FILE_NAME + ", using defaults");
        }
        this.isLoaded = true;
    }

    public void save() {
        if (!this.isLoaded) {
            return;
        }
        try {
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(CONFIG_FILE_NAME)));
            e.writeObject(this.config);
            e.close();
            log.info("Saved settings to " + CONFIG_FILE_NAME);
        }
        catch (FileNotFoundException e) {
            log.info("Error saving " + CONFIG_FILE_NAME + e);
        }
    }

    public Node getRoot() {
        if (!this.isLoaded) {
            this.load();
        }
        return new Node("root", this.config);
    }

    static {
        new File(FileUtil.RUSEFI_SETTINGS_FOLDER).mkdirs();
        CONFIG_FILE_NAME = FileUtil.RUSEFI_SETTINGS_FOLDER + File.separator + "console_properties.xml";
    }
}

