/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.devexperts.logging.Logging;
import com.rusefi.AvailableHardware;
import com.rusefi.CompatibilityOptional;
import com.rusefi.CompatibilitySet;
import com.rusefi.FileLog;
import com.rusefi.SerialPortScanner;
import com.rusefi.StartupFrame;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.maintenance.jobs.AsyncJob;
import com.rusefi.maintenance.jobs.AsyncJobWithContext;
import com.rusefi.maintenance.jobs.DfuAutoJob;
import com.rusefi.maintenance.jobs.DfuManualJob;
import com.rusefi.maintenance.jobs.OpenBltAutoJob;
import com.rusefi.maintenance.jobs.OpenBltManualJob;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.basic.LogoLabelPopupMenu;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import com.rusefi.ui.basic.UpdateCalibrations;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.widgets.ToolButtons;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.putgemin.VerticalFlowLayout;

public class BasicUpdaterPanel {
    private static final Logging log = Logging.getLogging(BasicUpdaterPanel.class);
    private final JPanel content = new JPanel(new VerticalFlowLayout());
    private final boolean isObfuscated = FindFileHelper.isObfuscated();
    private final JLabel statusMessage = new JLabel();
    private final JButton updateFirmwareButton = ProgramSelector.createUpdateFirmwareButton();
    private final JButton updateCalibrationsButton = new JButton("Update Calibrations", AutoupdateUtil.loadIcon("writeconfig48.png"));
    private final SingleAsyncJobExecutor singleAsyncJobExecutor;
    private final UpdateCalibrations updateCalibrations;
    private volatile Optional<AsyncJob> updateFirmwareJob = Optional.empty();
    private volatile Optional<SerialPortScanner.PortResult> portToUpdateCalibrations = Optional.empty();

    BasicUpdaterPanel(boolean showUrlLabel, UpdateOperationCallbacks updateOperationCallbacks, boolean doNotUseStatusWindow) {
        this.singleAsyncJobExecutor = new SingleAsyncJobExecutor(updateOperationCallbacks, doNotUseStatusWindow, () -> SwingUtilities.invokeLater(this::refreshButtons));
        this.updateCalibrations = new UpdateCalibrations(this.singleAsyncJobExecutor);
        if (FileLog.isWindows()) {
            Optional<JPanel> newReleaseNotification = StartupFrame.newReleaseAnnounce("rusefi_updater.exe", "center", () -> 0);
            if (newReleaseNotification.isPresent()) {
                this.content.add(newReleaseNotification.get());
            }
            this.content.add(ToolButtons.createShowDeviceManagerButton());
            this.content.add(StartupFrame.binaryModificationControl());
            this.updateFirmwareButton.addActionListener(this::onUpdateFirmwareButtonClicked);
            this.updateFirmwareButton.setEnabled(false);
            this.statusMessage.setForeground(Color.red);
            this.content.add(this.statusMessage);
            this.content.add(this.updateFirmwareButton);
        } else {
            this.content.add(new JLabel("Sorry only works on Windows"));
        }
        this.content.add(new HorizontalLine());
        JLabel logoLabel = LogoHelper.createLogoLabel();
        if (logoLabel != null) {
            String panamaUrl = ConnectionAndMeta.getProperties().getProperty("panama_url");
            if (panamaUrl != null) {
                logoLabel.setComponentPopupMenu(new LogoLabelPopupMenu(panamaUrl));
            }
            this.content.add(logoLabel);
        }
        if (showUrlLabel) {
            this.content.add(LogoHelper.createUrlLabel());
        }
        this.updateCalibrationsButton.addActionListener(this::onUpdateCalibrationsButtonClicked);
        this.updateCalibrationsButton.setEnabled(false);
        if (ConnectionAndMeta.showUpdateCalibrations()) {
            this.content.add(this.updateCalibrationsButton);
        }
    }

    private void hideStatusMessage() {
        this.statusMessage.setText(" ");
    }

    public void updateStatus(String niceStatus) {
        this.statusMessage.setText(niceStatus);
    }

    public void onHardwareUpdated(AvailableHardware currentHardware) {
        this.hideStatusMessage();
        this.updateUpdateFirmwareJob(currentHardware);
        this.updatePortToUpdateCalibrations(currentHardware);
    }

    private void updateUpdateFirmwareJob(AvailableHardware currentHardware) {
        if (currentHardware.isDfuFound()) {
            this.setUpdateFirmwareJob(new DfuManualJob());
        } else {
            Set<SerialPortScanner.SerialPortType> portTypesToUpdateFirmware = this.isObfuscated ? CompatibilitySet.of(SerialPortScanner.SerialPortType.EcuWithOpenblt, SerialPortScanner.SerialPortType.OpenBlt) : CompatibilitySet.of(SerialPortScanner.SerialPortType.Ecu, SerialPortScanner.SerialPortType.EcuWithOpenblt);
            List<SerialPortScanner.PortResult> portsToUpdateFirmware = currentHardware.getKnownPorts(portTypesToUpdateFirmware);
            switch (portsToUpdateFirmware.size()) {
                case 0: {
                    this.resetUpdateFirmwareJob("ECU not found");
                    break;
                }
                case 1: {
                    SerialPortScanner.PortResult portToUpdateFirmware = portsToUpdateFirmware.get(0);
                    AsyncJobWithContext job = null;
                    SerialPortScanner.SerialPortType portType = portToUpdateFirmware.type;
                    switch (portType) {
                        case Ecu: {
                            job = new DfuAutoJob(portToUpdateFirmware, this.updateFirmwareButton);
                            break;
                        }
                        case EcuWithOpenblt: {
                            job = new OpenBltAutoJob(portToUpdateFirmware, this.updateFirmwareButton);
                            break;
                        }
                        case OpenBlt: {
                            job = new OpenBltManualJob(portToUpdateFirmware, this.updateFirmwareButton);
                            break;
                        }
                        default: {
                            log.error(String.format("Unexpected port type: %s", new Object[]{portType}));
                        }
                    }
                    this.setUpdateFirmwareJob(job);
                    break;
                }
                default: {
                    this.resetUpdateFirmwareJob(String.format("Multiple ECUs found on: %s", portsToUpdateFirmware.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
                }
            }
        }
    }

    private void setUpdateFirmwareJob(AsyncJob updateFirmwareJob) {
        this.updateFirmwareJob = Optional.of(updateFirmwareJob);
        this.hideStatusMessage();
        this.refreshButtons();
        Optional<Object> updateFirmwareButtonText = Optional.empty();
        if (updateFirmwareJob instanceof OpenBltAutoJob) {
            updateFirmwareButtonText = Optional.of("Auto Update Firmware");
        } else if (updateFirmwareJob instanceof OpenBltManualJob) {
            updateFirmwareButtonText = Optional.of("Blt Update Firmware");
        } else if (updateFirmwareJob instanceof DfuAutoJob) {
            updateFirmwareButtonText = Optional.of("Update Firmware");
        } else if (updateFirmwareJob instanceof DfuManualJob) {
            updateFirmwareButtonText = Optional.of("Update Firmware via DFU");
        } else {
            log.error(String.format("Unexpected job type: %s", updateFirmwareJob.getClass().getSimpleName()));
        }
        updateFirmwareButtonText.ifPresent(this.updateFirmwareButton::setText);
    }

    private void resetUpdateFirmwareJob(String reason) {
        this.updateFirmwareJob = Optional.empty();
        this.updateFirmwareButton.setEnabled(false);
        this.statusMessage.setText(reason);
    }

    private void updatePortToUpdateCalibrations(AvailableHardware currentHardware) {
        List<SerialPortScanner.PortResult> ecuPortsToUpdateCalibrations = currentHardware.getKnownPorts(CompatibilitySet.of(SerialPortScanner.SerialPortType.Ecu, SerialPortScanner.SerialPortType.EcuWithOpenblt));
        switch (ecuPortsToUpdateCalibrations.size()) {
            case 0: {
                this.resetPortToUpdateCalibrations();
                log.info("No ECU ports to update calibrations found");
                break;
            }
            case 1: {
                this.setPortToUpdateCalibrations(ecuPortsToUpdateCalibrations.get(0));
                break;
            }
            default: {
                this.resetPortToUpdateCalibrations();
                log.info(String.format("Multiple ECU ports to update calibrations found on: %s", ecuPortsToUpdateCalibrations.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
            }
        }
    }

    private void setPortToUpdateCalibrations(SerialPortScanner.PortResult port) {
        this.portToUpdateCalibrations = Optional.of(port);
        this.refreshButtons();
    }

    private void resetPortToUpdateCalibrations() {
        this.portToUpdateCalibrations = Optional.empty();
        this.updateCalibrationsButton.setEnabled(false);
    }

    private void onUpdateFirmwareButtonClicked(ActionEvent actionEvent) {
        this.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.updateFirmwareJob, value -> this.singleAsyncJobExecutor.startJob((AsyncJob)value, this.updateFirmwareButton), () -> log.error("Update firmware job is is not defined."));
        this.refreshButtons();
    }

    private void onUpdateCalibrationsButtonClicked(ActionEvent actionEvent) {
        this.disableButtons();
        CompatibilityOptional.ifPresentOrElse(this.portToUpdateCalibrations, port -> this.updateCalibrations.updateCalibrationsAction((SerialPortScanner.PortResult)port, this.updateCalibrationsButton), () -> JOptionPane.showMessageDialog(this.updateCalibrationsButton, "Device is not connected", "Error", 0));
        this.refreshButtons();
    }

    private void refreshButtons() {
        this.updateFirmwareButton.setEnabled(this.updateFirmwareJob.isPresent() && this.singleAsyncJobExecutor.isNotInProgress());
        this.updateCalibrationsButton.setEnabled(this.portToUpdateCalibrations.isPresent() && this.singleAsyncJobExecutor.isNotInProgress());
    }

    private void disableButtons() {
        this.updateFirmwareButton.setEnabled(false);
        this.updateCalibrationsButton.setEnabled(false);
    }

    public Component getContent() {
        return this.content;
    }
}

