/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.NamedThreadFactory;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCategory;
import com.rusefi.core.SensorCentral;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ui.GaugesPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ThreadFactory;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class SensorLiveGraph
extends JPanel {
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("SensorLiveGraph", true);
    private static final int COUNT = 30;
    private static final String SENSOR_TYPE = "sensor";
    private static final String PERIOD = "period";
    private static final String USE_AUTO_SCALE = "auto_scale";
    private static final String UPPER = "upper";
    private static final String LOWER = "lower";
    private final LinkedList<Double> values = new LinkedList();
    private final Node config;
    private final JMenuItem extraItem;
    @NotNull
    private ChangePeriod period;
    private Sensor sensor;
    private boolean autoScale;
    private double customUpper;
    private double customLower;

    public SensorLiveGraph(Node config, Sensor defaultSensor, JMenuItem extraItem) {
        this.config = config;
        this.extraItem = extraItem;
        String gaugeName = config.getProperty(SENSOR_TYPE, defaultSensor.name());
        this.sensor = Sensor.lookup(gaugeName, defaultSensor);
        Thread thread = THREAD_FACTORY.newThread(this.createRunnable());
        thread.start();
        this.period = ChangePeriod.lookup(config.getProperty(PERIOD));
        this.autoScale = config.getBoolProperty(USE_AUTO_SCALE);
        this.customUpper = config.getDoubleProperty(UPPER, Double.NaN);
        this.customLower = config.getDoubleProperty(LOWER, Double.NaN);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    SensorLiveGraph.this.showPopupMenu(e);
                }
            }
        };
        this.addMouseListener(mouseListener);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    @NotNull
    private Runnable createRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(SensorLiveGraph.this.period.getMs());
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                    if (GaugesPanel.IS_PAUSED) continue;
                    SensorLiveGraph.this.grabNewValue();
                }
            }
        };
    }

    private void grabNewValue() {
        double value = SensorCentral.getInstance().getValue(this.sensor);
        this.addValue(value);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoupdateUtil.trueLayout(SensorLiveGraph.this);
            }
        });
    }

    private void showPopupMenu(MouseEvent e) {
        JPopupMenu pm = new JPopupMenu();
        this.addChangeSensorItems(pm);
        pm.add(new JSeparator());
        this.addChangePeriodItems(pm);
        JMenu scale = new JMenu("Scale");
        final JCheckBoxMenuItem as = new JCheckBoxMenuItem("Auto scale");
        as.setSelected(this.autoScale);
        as.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorLiveGraph.this.autoScale = as.isSelected();
                SensorLiveGraph.this.config.setBoolProperty(SensorLiveGraph.USE_AUTO_SCALE, SensorLiveGraph.this.autoScale);
            }
        });
        ((Container)scale).add(as);
        final JCheckBoxMenuItem lowerValue = new JCheckBoxMenuItem("Use custom lower");
        lowerValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (lowerValue.isSelected()) {
                    String initial = Double.isNaN(SensorLiveGraph.this.customLower) ? "" : Double.toString(SensorLiveGraph.this.customLower);
                    String lower = JOptionPane.showInputDialog("Enter lower value", (Object)initial);
                    if (!Node.isNumeric(lower)) {
                        return;
                    }
                    SensorLiveGraph.this.customLower = Double.parseDouble(lower);
                    SensorLiveGraph.this.config.setProperty(SensorLiveGraph.LOWER, SensorLiveGraph.this.customLower);
                }
            }
        });
        final JCheckBoxMenuItem upperValue = new JCheckBoxMenuItem("Use custom upper");
        upperValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (upperValue.isSelected()) {
                    String initial = Double.isNaN(SensorLiveGraph.this.customUpper) ? "" : Double.toString(SensorLiveGraph.this.customUpper);
                    String upper = JOptionPane.showInputDialog("Enter upper value", (Object)initial);
                    if (!Node.isNumeric(upper)) {
                        return;
                    }
                    SensorLiveGraph.this.customUpper = Double.parseDouble(upper);
                    SensorLiveGraph.this.config.setProperty(SensorLiveGraph.UPPER, SensorLiveGraph.this.customUpper);
                }
            }
        });
        ((Container)scale).add(upperValue);
        ((Container)scale).add(lowerValue);
        pm.add(scale);
        pm.add(this.extraItem);
        pm.show(e.getComponent(), e.getX(), e.getY());
    }

    private void addChangePeriodItems(JPopupMenu pm) {
        JMenu mi = new JMenu("Refresh period");
        pm.add(mi);
        for (final ChangePeriod cp : ChangePeriod.values()) {
            JCheckBoxMenuItem i = new JCheckBoxMenuItem(cp.getText());
            i.setSelected(cp == this.period);
            i.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SensorLiveGraph.this.period = cp;
                    SensorLiveGraph.this.config.setProperty(SensorLiveGraph.PERIOD, SensorLiveGraph.this.period.getMs());
                }
            });
            ((Container)mi).add(i);
        }
    }

    private void addChangeSensorItems(JPopupMenu pm) {
        for (SensorCategory sc : SensorCategory.values()) {
            JMenu cmi = new JMenu(sc.getName());
            pm.add(cmi);
            for (final Sensor s : Sensor.getSensorsForCategory(sc.getName())) {
                JMenuItem mi = new JMenuItem(s.getName());
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SensorLiveGraph.this.setSensor(s);
                    }
                });
                ((Container)cmi).add(mi);
            }
        }
    }

    private synchronized void setSensor(Sensor sensor) {
        this.sensor = sensor;
        this.values.clear();
        this.config.setProperty(SENSOR_TYPE, sensor.name());
    }

    private synchronized void addValue(double value) {
        if (this.values.size() > 30) {
            this.values.removeFirst();
        }
        this.values.add(value);
    }

    @Override
    public synchronized void paint(Graphics g) {
        super.paint(g);
        Dimension d = this.getSize();
        if (d.height < 5) {
            return;
        }
        g.setColor(Color.black);
        VisibleRange range = this.getRange();
        this.paintGraph(g, d, range.minValue, range.maxValue);
        g.setColor(Color.red);
        int minY = d.height;
        int maxY = g.getFont().getSize();
        g.drawString(String.format("%.2f", range.minValue), 5, minY);
        g.drawString(String.format("%.2f", (range.minValue + range.maxValue) / 2.0), 5, (minY + maxY) / 2);
        g.drawString(String.format("%.2f", range.maxValue), 5, maxY);
        g.setColor(Color.blue);
        String sensorName = this.sensor.getName() + " ";
        int nameWidth = g.getFontMetrics().stringWidth(sensorName);
        g.drawString(sensorName, d.width - nameWidth, g.getFont().getSize());
        Font f = g.getFont();
        g.setFont(new Font(f.getName(), f.getStyle(), 3 * f.getSize()));
        if (!this.values.isEmpty()) {
            this.paintLastValue(g, d);
        }
    }

    private VisibleRange getRange() {
        VisibleRange range = this.autoScale ? VisibleRange.findRange(this.values) : new VisibleRange(Double.isNaN(this.customLower) ? this.sensor.getMinValue() : this.customLower, Double.isNaN(this.customUpper) ? this.sensor.getMaxValue() : this.customUpper);
        return range;
    }

    private void paintLastValue(Graphics g, Dimension d) {
        Double last = this.values.getLast();
        if (!Double.isNaN(last)) {
            String currentValue = String.format("%.2f", last);
            g.drawString(currentValue, (d.width - g.getFontMetrics().stringWidth(currentValue)) / 2, d.height / 2 + g.getFont().getSize() / 2);
        }
    }

    private void paintGraph(Graphics g, Dimension d, double minValue, double maxValue) {
        int index = 0;
        int prevX = 0;
        int prevY = 0;
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            double value = (Double)iterator.next();
            int x = d.width * index / this.values.size();
            int y = (int)((double)d.height - (value - minValue) * (double)d.height / (maxValue - minValue));
            g.drawOval(x, y, 3, 3);
            if (index > 0) {
                g.drawLine(x, y, prevX, prevY);
            }
            prevX = x;
            prevY = y;
            ++index;
        }
    }

    private static class VisibleRange {
        private final double minValue;
        private final double maxValue;

        public VisibleRange(double minValue, double maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public static VisibleRange findRange(LinkedList<Double> values) {
            double minValue = Double.MAX_VALUE;
            double maxValue = -1.7976931348623157E308;
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                double value = (Double)iterator.next();
                minValue = Math.min(minValue, value);
                maxValue = Math.max(maxValue, value);
            }
            if (minValue == maxValue) {
                minValue = 0.9 * maxValue - 1.0;
                maxValue = 1.1 * maxValue + 1.0;
            } else {
                double diff = maxValue - minValue;
                minValue -= 0.05 * diff;
                maxValue += 0.05 * diff;
            }
            return new VisibleRange(minValue, maxValue);
        }
    }

    static enum ChangePeriod {
        _3000(3000, "3 seconds"),
        _1000(1000, "1 second"),
        _200(200, "second / 5"),
        _100(100, "second / 10"),
        _50(50, "second / 20");

        private final int ms;
        private final String text;

        private ChangePeriod(int ms, String text) {
            this.ms = ms;
            this.text = text;
        }

        public int getMs() {
            return this.ms;
        }

        public String getText() {
            return this.text;
        }

        public static ChangePeriod lookup(String value) {
            for (ChangePeriod cp : ChangePeriod.values()) {
                if (!(cp.getMs() + "").equals(value)) continue;
                return cp;
            }
            return _200;
        }
    }
}

