/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImageWithMeta;
import com.opensr5.io.ConfigurationImageFile;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.IoHelper;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class BinaryProtocolLocalCache {
    private static final Logging log = Logging.getLogging(BinaryProtocol.class);
    public static final String STATE_FOLDER = "state/";
    static final String CONFIGURATION_RUSEFI_XML = "state/current_configuration.msq";
    static final String CONFIGURATION_RUSEFI_BINARY = "state/current_configuration.zip";
    public static boolean DISABLE_LOCAL_CONFIGURATION_CACHE;

    @NotNull
    static ConfigurationImageWithMeta getAndValidateLocallyCached(BinaryProtocol binaryProtocol) {
        ConfigurationImageWithMeta localCached;
        if (DISABLE_LOCAL_CONFIGURATION_CACHE) {
            return ConfigurationImageWithMeta.VOID;
        }
        try {
            localCached = ConfigurationImageFile.readFromFile(CONFIGURATION_RUSEFI_BINARY);
        }
        catch (IOException e) {
            log.error("Error reading state/current_configuration.zip: no worries " + e);
            return ConfigurationImageWithMeta.VOID;
        }
        if (!localCached.isEmpty()) {
            int crcOfLocallyCachedConfiguration = IoHelper.getCrc32(localCached.getConfigurationImage().getContent());
            log.info(String.format("state/current_configuration.zip Local cache CRC %x\n", crcOfLocallyCachedConfiguration));
            int crcFromController = binaryProtocol.getCrcFromController(localCached.getConfigurationImage().getSize());
            if (crcOfLocallyCachedConfiguration == crcFromController) {
                return localCached;
            }
        }
        return ConfigurationImageWithMeta.VOID;
    }

    static {
        new File(STATE_FOLDER).mkdirs();
    }
}

