/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.core.ISensorCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorsHolder;
import com.rusefi.core.ValueSource;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class SensorCentral
implements ISensorCentral {
    private static final SensorCentral INSTANCE = new SensorCentral();
    private final SensorsHolder sensorsHolder = new SensorsHolder();
    private final Map<Sensor, List<SensorListener>> sensorListeners = new EnumMap<Sensor, List<SensorListener>>(Sensor.class);
    private final List<ResponseListener> listeners = new CopyOnWriteArrayList<ResponseListener>();
    private byte[] response;

    public static SensorCentral getInstance() {
        return INSTANCE;
    }

    private SensorCentral() {
    }

    @Override
    public void grabSensorValues(byte[] response) {
        this.response = response;
        ISensorCentral.super.grabSensorValues(response);
        for (ResponseListener listener : this.listeners) {
            listener.onSensorUpdate();
        }
    }

    public byte[] getResponse() {
        return this.response;
    }

    @Override
    public double getValue(Sensor sensor) {
        return this.sensorsHolder.getValue(sensor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setValue(double value, Sensor sensor) {
        List<SensorListener> listeners;
        boolean isUpdated = this.sensorsHolder.setValue(value, sensor);
        Map<Sensor, List<SensorListener>> map = this.sensorListeners;
        synchronized (map) {
            listeners = this.sensorListeners.get(sensor);
        }
        if (listeners == null) {
            return isUpdated;
        }
        for (SensorListener listener : listeners) {
            listener.onSensorUpdate(value);
        }
        return isUpdated;
    }

    public void addListener(ResponseListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISensorCentral.ListenerToken addListener(Sensor sensor, SensorListener listener) {
        List<SensorListener> listeners;
        Map<Sensor, List<SensorListener>> map = this.sensorListeners;
        synchronized (map) {
            listeners = this.sensorListeners.get(sensor);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<SensorListener>();
            }
            this.sensorListeners.put(sensor, listeners);
        }
        listeners.add(listener);
        return new ISensorCentral.ListenerToken(this, sensor, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Sensor sensor, SensorListener listener) {
        List<SensorListener> listeners;
        Map<Sensor, List<SensorListener>> map = this.sensorListeners;
        synchronized (map) {
            listeners = this.sensorListeners.get(sensor);
        }
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    @Override
    public ValueSource getValueSource(Sensor sensor) {
        return () -> this.getValue(sensor);
    }

    public static interface ResponseListener {
        public void onSensorUpdate();
    }

    public static interface SensorListener {
        public void onSensorUpdate(double var1);
    }
}

