/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.trigger;

import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.enums.trigger_type_e;
import com.rusefi.trigger.TriggerSignal;
import com.rusefi.trigger.TriggerWheelInfo;
import com.rusefi.trigger.WaveState;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.engine.UpDownImage;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.waves.EngineReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class TriggerImage {
    private static final String OUTPUT_FOLDER = "triggers";
    private static final String TOP_MESSAGE = "rusEFI (c) 2012-2025";
    private static final int WHEEL_BORDER = 20;
    private static final int WHEEL_DIAMETER = 500;
    private static final int SMALL_DIAMETER = 420;
    private static final int _180 = 180;
    public static final int MIN_TIME = 720;
    public static int EXTRA_COUNT = 1;
    private static int sleepAtEnd;
    private static trigger_type_e onlyOneTrigger;

    private static String getTriggerName(TriggerWheelInfo triggerName) {
        switch (TriggerImage.findByOrdinal(triggerName.getId())) {
            case TT_FORD_ASPIRE: {
                return "Ford Aspire";
            }
            case TT_VVT_BOSCH_QUICK_START: {
                return "Bosch Quick Start";
            }
            case TT_MAZDA_MIATA_NA: {
                return "Miata NA";
            }
            case TT_SUBARU_SVX: {
                return "Subaru SVX";
            }
            case TT_HONDA_K_CRANK_12_1: {
                return "Honda K 1/12";
            }
            case TT_SUBARU_7_6: {
                return "Subaru 7/6";
            }
            case TT_GM_24x_3: {
                return "GM 24x 3";
            }
            case TT_GM_24x_5: {
                return "GM 24x 5";
            }
            case TT_DODGE_NEON_1995: {
                return "Dodge Neon 1995";
            }
            case TT_DODGE_NEON_1995_ONLY_CRANK: {
                return "Dodge Neon 1995 crank only";
            }
            case TT_SKODA_FAVORIT: {
                return "Skoda Favorit";
            }
            case TT_GM_7X: {
                return "GM 7x";
            }
            case TT_CHRYSLER_NGC_36_2_2: {
                return "Chrysler NGC 36/2/2";
            }
            case TT_HALF_MOON: {
                return "Half Moon";
            }
            case TT_NARROW_SINGLE_TOOTH: {
                return "Narrow Single Tooth";
            }
            case TT_JEEP_4_CYL: {
                return "Jeep 4 cylinder";
            }
            case TT_JEEP_18_2_2_2: {
                return "18/2/2/2";
            }
            case TT_RENIX_44_2_2: {
                return "44/2/2";
            }
            case TT_RENIX_66_2_2_2: {
                return "66/2/2/2";
            }
            case TT_TOOTHED_WHEEL_36_1: {
                return "36/1";
            }
            case TT_TOOTHED_WHEEL_36_2: {
                return "36/2";
            }
            case TT_TRI_TACH: {
                return "TriTach";
            }
            case TT_TOOTHED_WHEEL_60_2: {
                return "60/2";
            }
            case TT_GM_60_2_2_2: {
                return "GM 60/2/2/2";
            }
        }
        return triggerName.getTriggerName();
    }

    public static void main(String[] args) throws InvocationTargetException, InterruptedException {
        String workingFolder = args.length < 1 ? TriggerWheelInfo.DEFAULT_WORK_FOLDER : args[0];
        if (args.length > 1) {
            onlyOneTrigger = TriggerImage.findByOrdinal(Integer.parseInt(args[1]));
        }
        if (args.length > 2) {
            sleepAtEnd = Integer.parseInt(args[2]);
        }
        FrameHelper f = new FrameHelper();
        JPanel content = new JPanel(new BorderLayout());
        TriggerPanel triggerPanel = new TriggerPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension((1 + EXTRA_COUNT) * 1, 480);
            }
        };
        JPanel topPanel = new JPanel(new FlowLayout());
        SwingUtilities.invokeAndWait(() -> {
            content.add((Component)topPanel, "North");
            content.add((Component)triggerPanel, "Center");
            f.showFrame(content);
            f.getFrame().setSize(900, 700);
            AutoupdateUtil.trueLayout(content);
        });
        SwingUtilities.invokeAndWait(() -> TriggerWheelInfo.readWheels(workingFolder, wheelInfo -> TriggerImage.onWheel(triggerPanel, topPanel, content, wheelInfo)));
        Thread.sleep(1000L * (long)sleepAtEnd);
        System.exit(-1);
    }

    private static void onWheel(TriggerPanel triggerPanel, JPanel topPanel, JPanel content, TriggerWheelInfo triggerWheelInfo) {
        if (onlyOneTrigger != null && TriggerImage.findByOrdinal(triggerWheelInfo.getId()) != onlyOneTrigger) {
            return;
        }
        topPanel.removeAll();
        JPanel firstWheelControl = TriggerImage.createWheelPanel(triggerWheelInfo.getFirstWheeTriggerSignals(), true, triggerWheelInfo);
        topPanel.add(firstWheelControl);
        topPanel.add(LogoHelper.createLogoLabel());
        List<WaveState> waves = TriggerImage.convertSignalsToWaves(triggerWheelInfo.getSignals());
        if (!waves.get((int)1).list.isEmpty()) {
            JPanel secondWheelControl = TriggerImage.createWheelPanel(triggerWheelInfo.getSecondWheeTriggerSignals(), false, triggerWheelInfo);
            topPanel.add(secondWheelControl);
        }
        AutoupdateUtil.trueLayout(topPanel);
        AutoupdateUtil.trueLayout(content);
        triggerPanel.tdcPosition = triggerWheelInfo.getTdcPosition();
        triggerPanel.gaps = triggerWheelInfo.getGaps();
        triggerPanel.syncEdge = triggerWheelInfo.getSyncEdge();
        triggerPanel.isKnown = triggerWheelInfo.isKnownOperationMode();
        triggerPanel.isCrankBased = triggerWheelInfo.isCrankBased();
        EngineReport re0 = new EngineReport(waves.get((int)0).list, 720, 720 * (1 + EXTRA_COUNT));
        System.out.println(re0);
        EngineReport re1 = new EngineReport(waves.get((int)1).list, 720, 720 * (1 + EXTRA_COUNT));
        triggerPanel.removeAll();
        UpDownImage upDownImage0 = new UpDownImage(re0, "trigger");
        upDownImage0.setRenderText(false);
        triggerPanel.image = upDownImage0;
        UpDownImage upDownImage1 = new UpDownImage(re1, "trigger");
        upDownImage1.setRenderText(false);
        boolean isSingleSensor = re1.getList().isEmpty();
        int height = isSingleSensor ? 1 : 2;
        triggerPanel.setLayout(new GridLayout(height, 1));
        triggerPanel.add(upDownImage0);
        if (!isSingleSensor) {
            triggerPanel.add(upDownImage1);
        }
        triggerPanel.name = TriggerImage.getTriggerName(triggerWheelInfo);
        AutoupdateUtil.trueLayout(triggerPanel);
        AutoupdateUtil.trueLayout(triggerPanel);
        content.paintImmediately(content.getVisibleRect());
        new File(OUTPUT_FOLDER).mkdir();
        UiUtils.saveImage(OUTPUT_FOLDER + File.separator + "trigger_" + (Object)((Object)TriggerImage.findByOrdinal(triggerWheelInfo.getId())) + ".png", content);
    }

    @NotNull
    private static JPanel createWheelPanel(final List<TriggerSignal> wheel, final boolean showTdc, final TriggerWheelInfo shape) {
        return new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                int middle = 270;
                if (showTdc) {
                    double tdcAngle = Math.toRadians(180.0 + shape.getTdcPositionIn360());
                    int smallX = (int)(250.0 * Math.sin(tdcAngle));
                    int smallY = (int)(250.0 * Math.cos(tdcAngle));
                    int tdcMarkRadius = 8;
                    g.setColor(UpDownImage.ENGINE_CYCLE_COLOR);
                    g.fillOval(middle + smallX - tdcMarkRadius, middle + smallY - tdcMarkRadius, 2 * tdcMarkRadius, 2 * tdcMarkRadius);
                    g.drawString("TDC", middle + smallX + tdcMarkRadius * 2, middle + smallY);
                }
                g.setColor(Color.black);
                for (int i = 0; i < wheel.size(); ++i) {
                    TriggerSignal current = (TriggerSignal)wheel.get(i);
                    TriggerImage.drawRadialLine(g, current.getAngle());
                    double nextAngle = i == wheel.size() - 1 ? 360.0 + ((TriggerSignal)wheel.get(0)).getAngle() : ((TriggerSignal)wheel.get(i + 1)).getAngle();
                    int arcDuration = (int)(current.getAngle() - nextAngle);
                    int arcStart = (int)TriggerImage.arcToRusEFI(nextAngle);
                    if (current.getState() == 1) {
                        g.drawArc(20, 20, 500, 500, arcStart, arcDuration);
                        continue;
                    }
                    int corner = 60;
                    g.drawArc(corner, corner, 420, 420, arcStart, arcDuration);
                }
                int dirArrow = 40;
                g.drawArc(middle - dirArrow, middle - dirArrow, 2 * dirArrow, 2 * dirArrow, 0, 180);
                g.drawLine(middle + dirArrow + 5, middle - 15, middle + dirArrow, middle);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(540, 540);
            }
        };
    }

    private static double arcToRusEFI(double angle) {
        return angle + 180.0 - 90.0;
    }

    private static void drawRadialLine(Graphics g, double angle) {
        int center = 270;
        double radianAngle = Math.toRadians(180.0 + angle);
        int smallX = (int)(210.0 * Math.sin(radianAngle));
        int smallY = (int)(210.0 * Math.cos(radianAngle));
        int largeX = (int)(250.0 * Math.sin(radianAngle));
        int largeY = (int)(250.0 * Math.cos(radianAngle));
        g.drawLine(center + smallX, center + smallY, center + largeX, center + largeY);
    }

    @NotNull
    static List<WaveState> convertSignalsToWaves(List<TriggerSignal> signals) {
        ArrayList<TriggerSignal> toShow = new ArrayList<TriggerSignal>(signals);
        for (int i = 1; i <= 2 + EXTRA_COUNT; ++i) {
            for (TriggerSignal s : signals) {
                toShow.add(new TriggerSignal(s.getWaveIndex(), s.getState(), s.getAngle() + (double)(i * 720), s.getGap()));
            }
        }
        ArrayList<WaveState> waves = new ArrayList<WaveState>();
        waves.add(new WaveState());
        waves.add(new WaveState());
        waves.add(new WaveState());
        for (TriggerSignal s : toShow) {
            WaveState.trigger_value_e signal = s.getState() == 0 ? WaveState.trigger_value_e.TV_LOW : WaveState.trigger_value_e.TV_HIGH;
            WaveState waveState = (WaveState)waves.get(s.getWaveIndex());
            waveState.handle(signal, s.getAngle(), s.getGap());
        }
        for (WaveState wave : waves) {
            wave.wrap();
        }
        return waves;
    }

    public static trigger_type_e findByOrdinal(int id) {
        for (trigger_type_e type : trigger_type_e.values()) {
            if (type.ordinal() != id) continue;
            return type;
        }
        throw new IllegalArgumentException("No type for " + id);
    }

    static {
        onlyOneTrigger = null;
    }

    private static class TriggerPanel
    extends JPanel {
        public String name = "";
        public String id;
        public double tdcPosition;
        public String syncEdge;
        public boolean isKnown;
        public boolean isCrankBased;
        public UpDownImage image;
        public TriggerWheelInfo.TriggerGaps gaps;

        private TriggerPanel() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Color.black);
            int w = this.getWidth();
            int off = g.getFontMetrics().stringWidth(TriggerImage.TOP_MESSAGE);
            g.drawString(TriggerImage.TOP_MESSAGE, w - off, g.getFont().getSize());
            String line = new Date().toString();
            off = g.getFontMetrics().stringWidth(line);
            g.drawString(line, w - off, 2 * g.getFont().getSize());
            Font f = g.getFont();
            g.setFont(new Font(f.getName(), 1, f.getSize() * 3));
            int h = this.getHeight();
            g.drawString(this.name, 50, (int)((double)h * 0.75));
            if (this.id != null) {
                g.drawString(this.id, 0, (int)((double)h * 0.9));
            }
            g.setColor(UpDownImage.ENGINE_CYCLE_COLOR);
            int tdcFontSize = (int)((double)f.getSize() * 1.5);
            g.setFont(new Font(f.getName(), 1, tdcFontSize));
            String tdcMessage = this.tdcPosition != 0.0 ? "TDC " + this.formatTdcPosition() + " degree from synchronization point" : "TDC at synchronization point";
            int y = tdcFontSize;
            String prefix = "     ";
            g.drawString(prefix + tdcMessage, 0, y);
            y += tdcFontSize;
            g.setColor(Color.darkGray);
            if (this.image == null) {
                return;
            }
            for (int i = 0; i < this.gaps.gapFrom.length; ++i) {
                String message = "Sync " + (i + 1) + ": From " + this.gaps.gapFrom[i] + " to " + this.gaps.gapTo[i];
                g.drawString(prefix + "       " + message, 0, y);
                y += tdcFontSize;
            }
            if (this.isKnown) {
                g.drawString(prefix + (this.isCrankBased ? "On crankshaft" : "On camshaft"), 0, y);
                y += tdcFontSize;
            }
            if (this.syncEdge != null) {
                g.drawString(prefix + this.syncEdge, 0, y);
                y += tdcFontSize;
            }
            int tdcX = this.image.engineReport.getTimeAxisTranslator().timeToScreen(720.0 + this.tdcPosition, w);
            g.drawLine(tdcX, 0, tdcX, h);
            Graphics2D g2 = (Graphics2D)g;
            g2.rotate(1.5707963267948966);
            g2.drawString("TDC", 160, -tdcX - 3);
            g2.rotate(-1.5707963267948966);
        }

        private String formatTdcPosition() {
            if ((double)((int)this.tdcPosition) == this.tdcPosition) {
                return Integer.toString((int)this.tdcPosition);
            }
            return Double.toString(this.tdcPosition);
        }
    }
}

