/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.core.MessagesCentral;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ui.LogSizeControl;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class WarningPanel {
    private static final String WARNING = "WARNING";
    private static final String ERROR = "firmware error";
    private final JPanel panel = new JPanel(new FlowLayout());
    private final JLabel label = new JLabel();
    private final JButton reset = new JButton("clear warning");
    private final Timer criticalErrorBlinking = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            WarningPanel.this.label.setVisible(!WarningPanel.this.label.isVisible());
            AutoupdateUtil.trueLayout(WarningPanel.this.label);
        }
    });

    public WarningPanel(Node config) {
        this.label.setForeground(Color.red);
        this.panel.add(this.label);
        Font currentFont = this.label.getFont();
        this.label.setFont(currentFont.deriveFont((float)((double)currentFont.getSize() * 1.5)));
        this.clear();
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarningPanel.this.clear();
            }
        });
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){
            boolean haveFatalError;

            @Override
            public void onMessage(Class clazz, String message) {
                if (this.haveFatalError) {
                    return;
                }
                if (message.startsWith("CRITICAL")) {
                    this.haveFatalError = true;
                    WarningPanel.this.criticalErrorBlinking.start();
                    WarningPanel.this.label.setText(message);
                    return;
                }
                if (message.startsWith(WarningPanel.WARNING) || message.startsWith(WarningPanel.ERROR)) {
                    WarningPanel.this.label.setText(message);
                    WarningPanel.this.reset.setEnabled(true);
                }
            }
        });
        this.panel.add(this.reset);
        this.panel.add(new JLabel("Writing logs to 'logs/'"));
        this.panel.add(new LogSizeControl(config).getContent());
    }

    private void clear() {
        this.label.setText("");
        this.reset.setEnabled(false);
    }

    public JPanel getPanel(Node config) {
        return this.panel;
    }
}

