/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;

public interface IntComparator {
    public int compare(int var1, int var2);

    default public IntComparator reversed() {
        return (IntComparator & Serializable)(i1, i2) -> this.compare(i2, i1);
    }

    default public IntComparator thenComparing(IntComparator other) {
        Objects.requireNonNull(other);
        return (IntComparator & Serializable)(i1, i2) -> {
            int res = this.compare(i1, i2);
            return res != 0 ? res : other.compare(i1, i2);
        };
    }

    default public <K> IntComparator thenComparing(IntFunction<? extends K> keyExtractor, Comparator<? super K> keyComparator) {
        return this.thenComparing(IntComparator.comparing(keyExtractor, keyComparator));
    }

    default public <K extends Comparable<? super K>> IntComparator thenComparing(IntFunction<? extends K> keyExtractor) {
        return this.thenComparing(IntComparator.comparing(keyExtractor));
    }

    default public IntComparator thenComparingInt(IntUnaryOperator keyExtractor) {
        return this.thenComparing(IntComparator.comparingInt(keyExtractor));
    }

    default public IntComparator thenComparingLong(IntToLongFunction keyExtractor) {
        return this.thenComparing(IntComparator.comparingLong(keyExtractor));
    }

    default public IntComparator thenComparingDouble(IntToDoubleFunction keyExtractor) {
        return this.thenComparing(IntComparator.comparingDouble(keyExtractor));
    }

    public static <K> IntComparator comparing(IntFunction<? extends K> keyExtractor, Comparator<? super K> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        return (IntComparator & Serializable)(i1, i2) -> keyComparator.compare((Object)keyExtractor.apply(i1), (Object)keyExtractor.apply(i2));
    }

    public static <K extends Comparable<? super K>> IntComparator comparing(IntFunction<? extends K> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (IntComparator & Serializable)(i1, i2) -> ((Comparable)keyExtractor.apply(i1)).compareTo(keyExtractor.apply(i2));
    }

    public static IntComparator comparingInt(IntUnaryOperator keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (IntComparator & Serializable)(i1, i2) -> Integer.compare(keyExtractor.applyAsInt(i1), keyExtractor.applyAsInt(i2));
    }

    public static IntComparator comparingLong(IntToLongFunction keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (IntComparator & Serializable)(i1, i2) -> Long.compare(keyExtractor.applyAsLong(i1), keyExtractor.applyAsLong(i2));
    }

    public static IntComparator comparingDouble(IntToDoubleFunction keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (IntComparator & Serializable)(i1, i2) -> Double.compare(keyExtractor.applyAsDouble(i1), keyExtractor.applyAsDouble(i2));
    }
}

