/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.common;

import com.rusefi.autotest.ControllerConnectorState;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.engine_type_e;
import com.rusefi.functional_tests.EcuTestHelper;

public class VssHardwareTestLogic {
    private static final int FREQUENCY = 160;

    public static void runIdleVssTest(EcuTestHelper ecu, String idlePin, String vssPin) {
        ecu.setEngineType(engine_type_e.FRANKENSO_MIATA_NA6_MAP);
        ecu.changeRpm(1000);
        ecu.sendCommand("set_trigger_simulator_pin 0 none");
        ecu.sendCommand("set_trigger_simulator_pin 1 none");
        ecu.sendCommand("set_trigger_input_pin 1 none");
        ecu.sendCommand("set_idle_pin " + idlePin);
        ecu.sendCommand("set idle_solenoid_freq 100");
        EcuTestHelper.assertSomewhatClose("VSS no input", 0.0, SensorCentral.getInstance().getValue(Sensor.vehicleSpeedKph));
        ecu.sendCommand("set vss_pin " + vssPin);
        BinaryProtocol.sleep(2000L);
        ecu.sendCommand("set driveWheelRevPerKm 500");
        EcuTestHelper.assertSomewhatClose("VSS with input", 145.58, SensorCentral.getInstance().getValue(Sensor.vehicleSpeedKph));
        if (ControllerConnectorState.firmwareVersion == null) {
            throw new IllegalStateException("firmwareVersion has not arrived");
        }
    }
}

