/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.io.LinkDecoder;
import org.jetbrains.annotations.NotNull;

public class ResponseBuffer {
    private final ResponseListener listener;
    private final StringBuffer pending = new StringBuffer();

    public ResponseBuffer(@NotNull ResponseListener listener) {
        this.listener = listener;
    }

    public void append(String append, LinkDecoder decoder) {
        this.pending.append(append);
        while (ResponseBuffer.hasCRLF(this.pending)) {
            int cr = this.pending.indexOf("\r");
            int lf = this.pending.indexOf("\n");
            if (cr != -1 && lf == -1) {
                lf = cr;
            }
            if (cr == -1 && lf != -1) {
                cr = lf;
            }
            if (cr == -1) continue;
            int endOfLine = Math.min(cr, lf);
            if (endOfLine > 0) {
                String fullLine = this.pending.substring(0, endOfLine);
                this.listener.onResponse(decoder.unpack(fullLine));
            }
            while (this.pending.length() > endOfLine && (this.pending.charAt(endOfLine) == '\r' || this.pending.charAt(endOfLine) == '\n')) {
                ++endOfLine;
            }
            this.pending.delete(0, endOfLine);
        }
    }

    private static boolean hasCRLF(StringBuffer str) {
        int cr = str.indexOf("\r");
        int lf = str.indexOf("\n");
        return cr != -1 || lf != -1;
    }

    public static interface ResponseListener {
        public void onResponse(String var1);
    }
}

