/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.EnumIniField;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.opensr5.ini.field.StringIniField;
import com.rusefi.CompatibilitySet;
import com.rusefi.core.Pair;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.tune.xml.Constant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.management.ObjectName;

public class IniFieldsAnalyzer {
    private static final Logging log = Logging.getLogging(IniFieldsAnalyzer.class);
    private static final Set<String> INI_FIELDS_TO_IGNORE = CompatibilitySet.of("byFirmwareVersion");
    private static final Set<String> boardSpecificIniFieldsToIgnore = ConnectionAndMeta.getNonMigratableIniFields();

    public static List<Pair<IniField, Constant>> findValuesToUpdate(IniFileModel prevIni, Map<String, Constant> prevValues, IniFileModel newIni, Map<String, Constant> newValues, UpdateOperationCallbacks callbacks) {
        ArrayList<Pair<IniField, Constant>> result = new ArrayList<Pair<IniField, Constant>>();
        Map<String, IniField> prevIniFields = prevIni.getAllIniFields();
        Map<String, IniField> newIniFields = newIni.getAllIniFields();
        for (Map.Entry<String, IniField> prevFieldEntry : prevIniFields.entrySet()) {
            String prevFieldName = prevFieldEntry.getKey();
            IniField newField = newIniFields.get(prevFieldName);
            if (newField == null) continue;
            Constant prevValue = prevValues.get(prevFieldName);
            Constant newValue = newValues.get(prevFieldName);
            if (prevValue != null && newValue != null) {
                if (Objects.equals(prevValue.getValue(), newValue.getValue())) continue;
                if (!Objects.equals(prevValue.getName(), newValue.getName())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its name is updated: `%s` -> `%s`", prevFieldName, prevValue.getName(), newValue.getName()));
                    continue;
                }
                if (!Objects.equals(prevValue.getUnits(), newValue.getUnits())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its units are updated: `%s` -> `%s`", prevFieldName, prevValue.getUnits(), newValue.getUnits()));
                    continue;
                }
                if (!Objects.equals(prevValue.getDigits(), newValue.getDigits())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its digits are updated: `%s` -> `%s`", prevFieldName, prevValue.getDigits(), newValue.getDigits()));
                    continue;
                }
                if (!Objects.equals(prevValue.getCols(), newValue.getCols())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its column count is updated: `%s` -> `%s`", prevFieldName, prevValue.getCols(), newValue.getCols()));
                    continue;
                }
                if (!Objects.equals(prevValue.getRows(), newValue.getRows())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its row count is updated: `%s` -> `%s`", prevFieldName, prevValue.getRows(), newValue.getRows()));
                    continue;
                }
                Optional<String> migratedValue = IniFieldsAnalyzer.tryMigrateValue(prevFieldEntry.getValue(), newField, prevValue.getValue(), callbacks);
                if (migratedValue.isPresent()) {
                    String valueToRestore = migratedValue.get();
                    if (!valueToRestore.equals(newValue.getValue())) {
                        log.info(String.format("Field `%s` is going to be restored: `%s` -> `%s`", prevFieldName, prevValue.getValue(), newValue.getValue()));
                        result.add(new Pair<IniField, Constant>(newField, newValue.cloneWithValue(valueToRestore)));
                        continue;
                    }
                    callbacks.logLine(String.format("We aren't going to restore field `%s`: it looks like its value is just renamed: `%s` -> `%s`", prevFieldName, prevValue.getValue(), newValue.getValue()));
                    continue;
                }
                log.warn(String.format("Field `%s` cannot be updated: `%s` -> `%s`", prevFieldName, prevFieldEntry.getValue(), newField));
                continue;
            }
            log.info(String.format("Field `%s` is missed in new .ini file", prevFieldName));
        }
        return result;
    }

    private static Optional<String> tryMigrateValue(IniField prevField, IniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<String> result = Optional.empty();
        String prevFieldName = prevField.getName();
        if (!INI_FIELDS_TO_IGNORE.contains(prevFieldName) && !boardSpecificIniFieldsToIgnore.contains(prevFieldName)) {
            if (prevField instanceof ScalarIniField) {
                if (newField instanceof ScalarIniField) {
                    if (IniFieldsAnalyzer.canScalarValueBeMigrated((ScalarIniField)prevField, (ScalarIniField)newField, callbacks)) {
                        result = Optional.of(prevValue);
                    }
                } else {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because it is no is no longer scalar in new .ini file", prevFieldName));
                }
            } else if (prevField instanceof StringIniField) {
                if (newField instanceof StringIniField) {
                    result = Optional.of(prevValue);
                } else {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because it is no longer string in new .ini file", prevFieldName));
                }
            } else if (prevField instanceof EnumIniField) {
                if (newField instanceof EnumIniField) {
                    result = IniFieldsAnalyzer.tryMigrateEnumValue((EnumIniField)prevField, (EnumIniField)newField, prevValue, callbacks);
                } else {
                    callbacks.logLine(String.format("WARNING! `%s` cannot be migrated because it is no longer enum in new .ini file", prevFieldName));
                }
            } else if (prevField instanceof ArrayIniField) {
                if (newField instanceof ArrayIniField) {
                    if (IniFieldsAnalyzer.canArrayValueBeMigrated((ArrayIniField)prevField, (ArrayIniField)newField, callbacks)) {
                        result = Optional.of(prevValue);
                    }
                } else {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because it is no longer array in new .ini file", prevFieldName));
                }
            } else {
                log.error(String.format("Unexpected field type: %s", prevField.getClass()));
            }
        }
        return result;
    }

    private static boolean canScalarValueBeMigrated(ScalarIniField prevField, ScalarIniField newField, UpdateOperationCallbacks callbacks) {
        boolean result = false;
        if (!Objects.equals(prevField.getUnits(), newField.getUnits())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because units are updated: `%s` -> `%s`", prevField.getName(), prevField, newField));
        } else if (!Objects.equals((Object)prevField.getType(), (Object)newField.getType())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because type is updated: `%s` -> `%s`", prevField.getName(), prevField, newField));
        } else if (!Objects.equals(prevField.getDigits(), newField.getDigits())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because digits are updated: `%s` -> `%s`", prevField.getName(), prevField, newField));
        } else {
            result = true;
        }
        return result;
    }

    private static Optional<String> tryMigrateEnumValue(EnumIniField prevField, EnumIniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<String> result = Optional.empty();
        if (!Objects.equals((Object)prevField.getType(), (Object)newField.getType())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because type is updated: `%s` -> `%s`", new Object[]{prevField.getName(), prevField.getType(), newField.getType()}));
        } else if (!Objects.equals(prevField.getBitSize0(), newField.getBitSize0())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because bit size 0 is updated: `%s` -> `%s`", prevField.getName(), prevField.getBitSize0(), newField.getBitSize0()));
        } else {
            EnumIniField.EnumKeyValueMap newFieldKeyValues = newField.getEnums();
            if (newFieldKeyValues.indexOf(prevValue) == -1) {
                if (newFieldKeyValues.isBitField()) {
                    int prevValueOrdinal = prevField.getEnums().indexOf(prevValue);
                    String migratedValue = newFieldKeyValues.get(prevValueOrdinal);
                    if (migratedValue != null) {
                        result = Optional.of(ObjectName.quote(migratedValue));
                    } else {
                        callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because of internal error: new enum doesn't value with ordinal %d", prevField.getName(), prevValueOrdinal));
                    }
                } else {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because value `%s` has disappeared", prevField.getName(), prevValue));
                }
            } else {
                result = Optional.of(prevValue);
            }
        }
        return result;
    }

    private static boolean canArrayValueBeMigrated(ArrayIniField prevField, ArrayIniField newField, UpdateOperationCallbacks callbacks) {
        boolean result = false;
        if (!Objects.equals((Object)prevField.getType(), (Object)newField.getType())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because type is updated: `%s` -> `%s`", new Object[]{prevField.getName(), prevField.getType(), newField.getType()}));
        } else if (!Objects.equals(prevField.getCols(), newField.getCols())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because column count is updated: `%s` -> `%s`", prevField.getName(), prevField.getCols(), newField.getCols()));
        } else if (!Objects.equals(prevField.getRows(), newField.getRows())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because row count is updated: `%s` -> `%s`", prevField.getName(), prevField.getRows(), newField.getRows()));
        } else if (!Objects.equals(prevField.getDigits(), newField.getDigits())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be migrated because digits are updated: `%s` -> `%s`", prevField.getName(), prevField.getDigits(), newField.getDigits()));
        } else {
            result = true;
        }
        return result;
    }
}

