/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.DataPoint;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.SmoothingFunction;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class SparkLine
extends JComponent {
    private static final Util UTIL = Util.INSTANCE;
    private static final DecimalFormat DF = new DecimalFormat("0.00");
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 128, 48);
    private boolean recreateImages = true;
    private final LinkedList<DataPoint> DATA_LIST;
    private List<Double> sortedList = new ArrayList<Double>(3600);
    private List<DataPoint> trashList;
    private List<Point2D> pointList;
    private final Color DISABLED_COLOR;
    private double start;
    private double stop;
    private double lo;
    private double hi;
    private int loIndex;
    private int hiIndex;
    private double offset;
    private double scaleY;
    private double rangeY;
    private boolean filled;
    private SmoothingFunction smoothFunction;
    private boolean smoothing;
    private float lineWidth;
    private LcdColor sparkLineColor;
    private Paint customSparkLineColor;
    private Color lineColor;
    private ColorDef areaFill;
    private Color customAreaFillTop;
    private Color customAreaFillBottom;
    private boolean lineShadowVisible;
    private boolean startStopIndicatorVisible;
    private boolean hiLoIndicatorVisible;
    private boolean backgroundVisible;
    private boolean infoLabelsVisible;
    private final Font INFO_LABEL_FONT;
    private BufferedImage sparkLineBackgroundImage;
    private BufferedImage startIndicatorImage;
    private BufferedImage stopIndicatorImage;
    private BufferedImage loIndicatorImage;
    private BufferedImage hiIndicatorImage;
    private BufferedImage sparkLineImage;
    private Shape disabledShape;
    private final RoundRectangle2D CLIP_SHAPE;
    private long timeFrame;
    private double pixelResolution;
    private double baseLineY;
    private boolean baseLineVisible;
    private boolean averageVisible;
    private boolean normalAreaVisible;
    private final Line2D AVERAGE_LINE;
    private final Rectangle2D NORMAL_AREA;
    private Color averageColor;
    private Color normalAreaColor;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            Container parent = SparkLine.this.getParent();
            if (SparkLine.this.getWidth() < SparkLine.this.getMinimumSize().width && SparkLine.this.getHeight() < SparkLine.this.getMinimumSize().height) {
                if (parent != null && SparkLine.this.getParent().getLayout() == null) {
                    SparkLine.this.setSize(SparkLine.this.getMinimumSize());
                } else {
                    SparkLine.this.setPreferredSize(SparkLine.this.getMinimumSize());
                }
            }
            if (parent != null && SparkLine.this.getParent().getLayout() == null) {
                SparkLine.this.setSize(SparkLine.this.getWidth(), SparkLine.this.getHeight());
            } else {
                SparkLine.this.setPreferredSize(new Dimension(SparkLine.this.getWidth(), SparkLine.this.getHeight()));
            }
            SparkLine.this.calcInnerBounds();
            SparkLine.this.recreateAllImages();
            SparkLine.this.init(((SparkLine)SparkLine.this).INNER_BOUNDS.width, ((SparkLine)SparkLine.this).INNER_BOUNDS.height);
        }
    };

    public SparkLine() {
        this.DATA_LIST = new LinkedList();
        this.trashList = new ArrayList<DataPoint>(512);
        this.pointList = new ArrayList<Point2D>(this.INNER_BOUNDS.width);
        this.DISABLED_COLOR = new Color(102, 102, 102, 178);
        this.scaleY = 1.0;
        this.rangeY = 0.0;
        this.filled = false;
        this.smoothFunction = SmoothingFunction.COSINUS;
        this.smoothing = false;
        this.lineWidth = 1.0f;
        this.sparkLineColor = LcdColor.WHITE_LCD;
        this.customSparkLineColor = Color.WHITE;
        this.lineColor = this.sparkLineColor.TEXT_COLOR;
        this.areaFill = ColorDef.RED;
        this.customAreaFillTop = new Color(1.0f, 1.0f, 1.0f, 0.4f);
        this.customAreaFillBottom = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        this.lineShadowVisible = false;
        this.startStopIndicatorVisible = true;
        this.hiLoIndicatorVisible = false;
        this.backgroundVisible = true;
        this.infoLabelsVisible = false;
        this.INFO_LABEL_FONT = new Font("Verdana", 0, 12);
        this.CLIP_SHAPE = new RoundRectangle2D.Double();
        this.timeFrame = 3600000L;
        this.baseLineVisible = false;
        this.averageVisible = false;
        this.normalAreaVisible = false;
        this.AVERAGE_LINE = new Line2D.Double(this.INNER_BOUNDS.x, 0.0, this.INNER_BOUNDS.x + this.INNER_BOUNDS.width, 0.0);
        this.NORMAL_AREA = new Rectangle2D.Double(this.INNER_BOUNDS.x, 0.0, this.INNER_BOUNDS.width, 0.0);
        this.averageColor = new Color(102, 216, 29);
        this.normalAreaColor = new Color(216, 29, 68, 25);
        this.createInitialImages();
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.addComponentListener(this.COMPONENT_LISTENER);
        this.repaint(this.INNER_BOUNDS);
    }

    private void init(int WIDTH, int HEIGHT) {
        double CORNER_RADIUS;
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return;
        }
        double d = CORNER_RADIUS = WIDTH > HEIGHT ? (double)HEIGHT * 0.095 : (double)WIDTH * 0.095;
        if (this.recreateImages) {
            if (this.sparkLineBackgroundImage != null) {
                this.sparkLineBackgroundImage.flush();
            }
            this.sparkLineBackgroundImage = this.create_SPARK_LINE_BACKGROUND_Image(WIDTH, HEIGHT);
            this.CLIP_SHAPE.setRoundRect(1.0, 1.0, WIDTH - 2, HEIGHT - 2, CORNER_RADIUS - 1.0, CORNER_RADIUS - 1.0);
            if (this.startIndicatorImage != null) {
                this.startIndicatorImage.flush();
            }
            this.startIndicatorImage = this.create_START_STOP_INDICATOR_Image(WIDTH);
            if (this.stopIndicatorImage != null) {
                this.stopIndicatorImage.flush();
            }
            this.stopIndicatorImage = this.create_START_STOP_INDICATOR_Image(WIDTH);
            if (this.loIndicatorImage != null) {
                this.loIndicatorImage.flush();
            }
            this.loIndicatorImage = this.create_LO_INDICATOR_Image(WIDTH);
            if (this.hiIndicatorImage != null) {
                this.hiIndicatorImage.flush();
            }
            this.hiIndicatorImage = this.create_HI_INDICATOR_Image(WIDTH);
        }
        this.recreateImages = false;
        this.disabledShape = new RoundRectangle2D.Double(0.0, 0.0, WIDTH, HEIGHT, CORNER_RADIUS, CORNER_RADIUS);
        this.pixelResolution = this.INNER_BOUNDS.getWidth() / (double)this.timeFrame;
        this.offset = (int)(0.06 * (double)WIDTH) < 8 ? 8.0 : (double)((int)(0.06 * (double)WIDTH));
        this.baseLineY = (double)(this.INNER_BOUNDS.y + this.INNER_BOUNDS.height) - ((0.0 - this.lo) * (1.0 / this.scaleY) + this.offset);
        if (!this.DATA_LIST.isEmpty()) {
            this.calculate(WIDTH, HEIGHT);
        }
        if (this.sparkLineImage != null) {
            this.sparkLineImage.flush();
        }
        this.sparkLineImage = this.createSparkLineImage(WIDTH, HEIGHT);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.INNER_BOUNDS.x, this.INNER_BOUNDS.y);
        if (this.backgroundVisible) {
            G2.drawImage((Image)this.sparkLineBackgroundImage, 0, 0, null);
            G2.setClip(this.CLIP_SHAPE);
        }
        if (this.infoLabelsVisible && this.INNER_BOUNDS.height > 40) {
            G2.setColor(this.sparkLineColor.TEXT_COLOR);
            G2.setFont(this.INFO_LABEL_FONT.deriveFont(0.12f * (float)this.INNER_BOUNDS.height));
            G2.drawString("hi: " + DF.format(this.hi), (int)((double)this.INNER_BOUNDS.width * 0.0277777778), 2 + G2.getFont().getSize());
            G2.drawString("lo: " + DF.format(this.lo), (int)((double)this.INNER_BOUNDS.width * 0.0277777778), this.INNER_BOUNDS.height - 4);
        }
        G2.drawImage((Image)this.sparkLineImage, 0, 0, null);
        if (this.baseLineVisible) {
            G2.setColor(Color.BLACK);
            G2.drawLine(this.INNER_BOUNDS.x, (int)this.baseLineY, this.INNER_BOUNDS.x + this.INNER_BOUNDS.width, (int)this.baseLineY);
        }
        if (this.normalAreaVisible) {
            G2.setColor(this.normalAreaColor);
            G2.fill(this.NORMAL_AREA);
        }
        if (this.averageVisible) {
            G2.setColor(this.averageColor);
            G2.draw(this.AVERAGE_LINE);
        }
        if (!this.isEnabled()) {
            G2.setColor(this.DISABLED_COLOR);
            G2.fill(this.disabledShape);
        }
        G2.translate(-this.INNER_BOUNDS.x, -this.INNER_BOUNDS.y);
        G2.dispose();
    }

    public void addDataPoint(double DATA) {
        for (DataPoint dataPoint : this.DATA_LIST) {
            if (System.currentTimeMillis() - dataPoint.getTimeStamp() <= this.timeFrame) continue;
            this.trashList.add(dataPoint);
        }
        for (DataPoint dataPoint : this.trashList) {
            this.DATA_LIST.remove(dataPoint);
        }
        this.trashList.clear();
        this.DATA_LIST.add(new DataPoint(System.currentTimeMillis(), DATA));
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public void addDataPoint(double DATA, long TIMESTAMP) {
        for (DataPoint dataPoint : this.DATA_LIST) {
            if (TIMESTAMP - dataPoint.getTimeStamp() <= this.timeFrame) continue;
            this.trashList.add(dataPoint);
        }
        for (DataPoint dataPoint : this.trashList) {
            this.DATA_LIST.remove(dataPoint);
        }
        this.trashList.clear();
        this.DATA_LIST.add(new DataPoint(TIMESTAMP, DATA));
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public List<DataPoint> getDataList() {
        LinkedList<DataPoint> dataListCopy = new LinkedList<DataPoint>();
        dataListCopy.addAll(this.DATA_LIST);
        return dataListCopy;
    }

    public void setDataList(LinkedList<DataPoint> dataList) {
        this.DATA_LIST.clear();
        this.DATA_LIST.addAll(dataList);
        this.repaint(this.INNER_BOUNDS);
    }

    public double getStart() {
        return this.start;
    }

    public double getStop() {
        return this.stop;
    }

    public double getLo() {
        return this.lo;
    }

    public double getHi() {
        return this.hi;
    }

    public double getVariance() {
        if (!this.DATA_LIST.isEmpty()) {
            double sum = 0.0;
            double sumOfSquares = 0.0;
            double average = 0.0;
            for (DataPoint dataPoint : this.DATA_LIST) {
                sumOfSquares += dataPoint.getValue() * dataPoint.getValue();
                sum += dataPoint.getValue();
            }
            average = sum / (double)this.DATA_LIST.size();
            return sumOfSquares / (double)this.DATA_LIST.size() - average * average;
        }
        return 0.0;
    }

    public double getAverage() {
        if (!this.DATA_LIST.isEmpty()) {
            double sum = 0.0;
            for (DataPoint dataPoint : this.DATA_LIST) {
                sum += dataPoint.getValue();
            }
            return sum / (double)this.DATA_LIST.size();
        }
        return 0.0;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public double getRange() {
        return this.rangeY;
    }

    public double getQ1() {
        if (this.DATA_LIST.size() > 2) {
            this.sortData();
            int stopIndex = this.sortedList.size() % 2 != 0 ? this.sortedList.size() / 2 : this.sortedList.size() / 2 - 1;
            return this.sortedList.subList(0, stopIndex).get(this.sortedList.subList(0, stopIndex).size() / 2);
        }
        return 0.0;
    }

    public double getQ2() {
        return this.getMedian();
    }

    public double getQ3() {
        if (this.DATA_LIST.size() > 2) {
            this.sortData();
            int startIndex = this.sortedList.size() / 2;
            return this.sortedList.subList(startIndex, this.sortedList.size() - 1).get(this.sortedList.subList(startIndex, this.sortedList.size() - 1).size() / 2);
        }
        return 0.0;
    }

    public double getMedian() {
        if (this.DATA_LIST.size() > 2) {
            this.sortData();
            if (this.sortedList.size() % 2 != 0) {
                return this.sortedList.get(this.sortedList.size() / 2);
            }
            return (this.sortedList.get(this.sortedList.size() / 2 - 1) + this.sortedList.get(this.sortedList.size() / 2)) / 2.0;
        }
        return 0.0;
    }

    public long getTimeFrame() {
        return this.timeFrame;
    }

    public void setTimeFrame(long TIME_FRAME) {
        this.timeFrame = TIME_FRAME;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public long getStartTimestamp() {
        if (this.DATA_LIST.isEmpty()) {
            return 0L;
        }
        return this.DATA_LIST.getFirst().getTimeStamp();
    }

    public long getStopTimestamp() {
        if (this.DATA_LIST.isEmpty()) {
            return 0L;
        }
        return this.DATA_LIST.getLast().getTimeStamp();
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean FILLED) {
        this.filled = FILLED;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isSmoothing() {
        return this.smoothing;
    }

    public void setSmoothing(boolean SMOOTHING) {
        this.smoothing = SMOOTHING;
        if (SMOOTHING) {
            this.hiLoIndicatorVisible = false;
        }
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public LcdColor getSparkLineColor() {
        return this.sparkLineColor;
    }

    public void setSparkLineColor(LcdColor LCD_COLOR) {
        this.lineColor = LCD_COLOR.TEXT_COLOR;
        this.sparkLineColor = LCD_COLOR;
        this.recreateImages = true;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public Paint getCustomSparkLineColor() {
        return this.customSparkLineColor;
    }

    public void setCustomSparkLineColor(Paint CUSTOM_SPARKLINE_COLOR) {
        this.customSparkLineColor = CUSTOM_SPARKLINE_COLOR;
        this.recreateImages = true;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color LINE_COLOR) {
        this.lineColor = LINE_COLOR;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public ColorDef getAreaFill() {
        return this.areaFill;
    }

    public void setAreaFill(ColorDef AREA_FILL_COLOR) {
        this.areaFill = AREA_FILL_COLOR;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getCustomAreaFillTop() {
        return this.customAreaFillTop;
    }

    public void setCustomAreaFillTop(Color CUSTOM_AREA_FILL_COLOR_TOP) {
        this.customAreaFillTop = CUSTOM_AREA_FILL_COLOR_TOP;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getCustomAreaFillBottom() {
        return this.customAreaFillBottom;
    }

    public void setCustomAreaFillBottom(Color CUSTOM_AREA_FILL_COLOR_BOTTOM) {
        this.customAreaFillBottom = CUSTOM_AREA_FILL_COLOR_BOTTOM;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float LINE_WIDTH) {
        this.lineWidth = LINE_WIDTH;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isLineShadowVisible() {
        return this.lineShadowVisible;
    }

    public void setLineShadow(boolean LINE_SHADOW_VISIBLE) {
        this.lineShadowVisible = LINE_SHADOW_VISIBLE;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isStartStopIndicatorVisible() {
        return this.startStopIndicatorVisible;
    }

    public void setStartStopIndicatorVisible(boolean START_STOP_INDICATOR_VISIBLE) {
        this.startStopIndicatorVisible = START_STOP_INDICATOR_VISIBLE;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isHiLoIndicatorVisible() {
        return this.hiLoIndicatorVisible;
    }

    public void setHiLoIndicatorVisible(boolean HI_LO_INDICATOR_VISIBLE) {
        this.hiLoIndicatorVisible = HI_LO_INDICATOR_VISIBLE;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isBackgroundVisible() {
        return this.backgroundVisible;
    }

    public void setBackgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.backgroundVisible = BACKGROUND_VISIBLE;
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isInfoLabelsVisible() {
        return this.infoLabelsVisible;
    }

    public void setInfoLabelsVisible(boolean INFO_LABELS_VISIBLE) {
        this.infoLabelsVisible = INFO_LABELS_VISIBLE;
        this.repaint(this.INNER_BOUNDS);
    }

    public SmoothingFunction getSmoothFunction() {
        return this.smoothFunction;
    }

    public void setSmoothFunction(SmoothingFunction SMOOTHING_FUNCTION) {
        this.smoothFunction = SMOOTHING_FUNCTION;
        this.init(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isBaseLineVisible() {
        return this.baseLineVisible;
    }

    public void setBaseLineVisible(boolean BASE_LINE_VISIBLE) {
        this.baseLineVisible = BASE_LINE_VISIBLE;
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isAverageVisible() {
        return this.averageVisible;
    }

    public void setAverageVisible(boolean AVERAGE_VISIBLE) {
        this.averageVisible = AVERAGE_VISIBLE;
        this.repaint(this.INNER_BOUNDS);
    }

    public boolean isNormalAreaVisible() {
        return this.normalAreaVisible;
    }

    public void setNormalAreaVisible(boolean NORMAL_AREA_VISIBLE) {
        this.normalAreaVisible = NORMAL_AREA_VISIBLE;
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getAverageColor() {
        return this.averageColor;
    }

    public void setAverageColor(Color AVERAGE_COLOR) {
        this.averageColor = AVERAGE_COLOR;
        this.repaint(this.INNER_BOUNDS);
    }

    public Color getNormalAreaColor() {
        return this.normalAreaColor;
    }

    public void setNormalAreaColor(Color NORMAL_AREA_COLOR) {
        this.normalAreaColor = UTIL.setAlpha(NORMAL_AREA_COLOR, 0.2f);
        this.repaint(this.INNER_BOUNDS);
    }

    public BufferedImage getAsImage() {
        BufferedImage IMAGE = UTIL.createImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        this.paintAll(G2);
        G2.dispose();
        return IMAGE;
    }

    private void calculate(int WIDTH, int HEIGHT) {
        int index;
        this.start = this.DATA_LIST.getFirst().getValue();
        this.stop = this.DATA_LIST.getLast().getValue();
        this.lo = this.DATA_LIST.getFirst().getValue();
        this.hi = this.DATA_LIST.getFirst().getValue();
        this.loIndex = 0;
        this.hiIndex = 0;
        int SIZE = this.DATA_LIST.size();
        for (index = 0; index < SIZE; ++index) {
            double y = this.DATA_LIST.get(index).getValue();
            this.calcHiLoValues(y, index);
        }
        this.rangeY = this.hi - this.lo;
        this.scaleY = this.rangeY / ((double)HEIGHT - this.offset * 2.0);
        this.pointList.clear();
        if (this.DATA_LIST.size() > 5 && this.smoothing) {
            this.smoothData();
        } else {
            for (index = 0; index < SIZE; ++index) {
                this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.get(index).getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (this.DATA_LIST.get(index).getValue() - this.lo) * (1.0 / this.scaleY) + this.offset));
            }
        }
        if (this.averageVisible || this.normalAreaVisible) {
            double AVERAGE = (this.getAverage() - this.lo) * (1.0 / this.scaleY) + this.offset;
            double STANDARD_DEVIATION = this.getStandardDeviation() * (1.0 / this.scaleY);
            this.NORMAL_AREA.setRect(this.INNER_BOUNDS.x, AVERAGE - STANDARD_DEVIATION, this.INNER_BOUNDS.width, 2.0 * STANDARD_DEVIATION);
            this.AVERAGE_LINE.setLine(this.INNER_BOUNDS.x, AVERAGE, this.INNER_BOUNDS.x + this.INNER_BOUNDS.width, AVERAGE);
        }
    }

    private void smoothData() {
        int SIZE = this.DATA_LIST.size();
        switch (this.smoothFunction) {
            case CONTINUOUS_AVERAGE: {
                this.pointList.add(new Point2D.Double(0.0, (this.DATA_LIST.getFirst().getValue() - this.lo) * (1.0 / this.scaleY) + this.offset));
                for (int i = 1; i < SIZE - 1; ++i) {
                    double y = this.continuousAverage(this.DATA_LIST.get(i - 1).getValue(), this.DATA_LIST.get(i).getValue(), this.DATA_LIST.get(i + 1).getValue());
                    this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.get(i).getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (y - this.lo) * (1.0 / this.scaleY) + this.offset));
                }
                this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.getLast().getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (this.DATA_LIST.getLast().getValue() - this.lo) * (1.0 / this.scaleY) + this.offset));
                break;
            }
            case CUBIC_SPLINE: {
                for (int i = 2; i < SIZE - 1; ++i) {
                    double y = this.cubicInterpolate(this.DATA_LIST.get(i - 2).getValue(), this.DATA_LIST.get(i - 1).getValue(), this.DATA_LIST.get(i).getValue(), this.DATA_LIST.get(i + 1).getValue(), 0.5);
                    this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.get(i).getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (y - this.lo) * (1.0 / this.scaleY) + this.offset));
                }
                break;
            }
            case HERMITE: {
                for (int i = 2; i < SIZE - 1; ++i) {
                    double y = this.hermiteInterpolate(this.DATA_LIST.get(i - 2).getValue(), this.DATA_LIST.get(i - 1).getValue(), this.DATA_LIST.get(i - 0).getValue(), this.DATA_LIST.get(i + 1).getValue(), 0.5, 0.0, 0.0);
                    this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.get(i).getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (y - this.lo) * (1.0 / this.scaleY) + this.offset));
                }
                break;
            }
            default: {
                for (int i = 0; i < SIZE - 1; ++i) {
                    double y = this.cosInterpolate(this.DATA_LIST.get(i).getValue(), this.DATA_LIST.get(i + 1).getValue(), 0.5);
                    this.pointList.add(new Point2D.Double((double)(this.DATA_LIST.get(i).getTimeStamp() - this.DATA_LIST.getFirst().getTimeStamp()) * this.pixelResolution, (y - this.lo) * (1.0 / this.scaleY) + this.offset));
                }
            }
        }
    }

    private void calcHiLoValues(double y, int index) {
        if (y < this.lo) {
            this.lo = y;
            this.loIndex = index;
        }
        if (y > this.hi) {
            this.hi = y;
            this.hiIndex = index;
        }
    }

    private void sortData() {
        this.sortedList.clear();
        for (DataPoint dataPoint : this.DATA_LIST) {
            this.sortedList.add(dataPoint.getValue());
        }
        Collections.sort(this.sortedList);
    }

    private double continuousAverage(double Y0, double Y1, double Y2) {
        double A = 1.0;
        double B = 1.0;
        double C = 1.0;
        return (1.0 * Y0 + 1.0 * Y1 + 1.0 * Y2) / 3.0;
    }

    private double cubicInterpolate(double Y0, double Y1, double Y2, double Y3, double MU) {
        double MU2 = MU * MU;
        double A0 = Y3 - Y2 - Y0 + Y1;
        double A1 = Y0 - Y1 - A0;
        double A2 = Y2 - Y0;
        double A3 = Y1;
        return A0 * MU * MU2 + A1 * MU2 + A2 * MU + A3;
    }

    private double cosInterpolate(double Y1, double Y2, double MU) {
        double MU2 = (1.0 - Math.cos(MU * Math.PI)) / 2.0;
        return Y1 * (1.0 - MU2) + Y2 * MU2;
    }

    private double hermiteInterpolate(double Y0, double Y1, double Y2, double Y3, double MU, double TENSION, double BIAS) {
        double MU2 = MU * MU;
        double Mu3 = MU2 * MU;
        double m0 = (Y1 - Y0) * (1.0 + BIAS) * (1.0 - TENSION) / 2.0;
        m0 += (Y2 - Y1) * (1.0 - BIAS) * (1.0 - TENSION) / 2.0;
        double m1 = (Y2 - Y1) * (1.0 + BIAS) * (1.0 - TENSION) / 2.0;
        double A0 = 2.0 * Mu3 - 3.0 * MU2 + 1.0;
        double A1 = Mu3 - 2.0 * MU2 + MU;
        double A2 = Mu3 - MU2;
        double A3 = -2.0 * Mu3 + 3.0 * MU2;
        return A0 * Y1 + A1 * m0 + A2 * (m1 += (Y3 - Y2) * (1.0 - BIAS) * (1.0 - TENSION) / 2.0) + A3 * Y2;
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, this.getWidth() - INSETS.left - INSETS.right, this.getHeight() - INSETS.top - INSETS.bottom);
    }

    public Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (dim.width < 64 || dim.height < 24) {
            dim = new Dimension(64, 24);
        }
        return dim;
    }

    @Override
    public void setMinimumSize(Dimension DIM) {
        int width = DIM.width < 64 ? 64 : DIM.width;
        int height = DIM.height < 24 ? 24 : DIM.height;
        super.setMinimumSize(new Dimension(width, height));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (dim.width > 1920 || dim.height > 720) {
            dim = new Dimension(1920, 720);
        }
        return dim;
    }

    @Override
    public void setMaximumSize(Dimension DIM) {
        int width = DIM.width > 1920 ? 1920 : DIM.width;
        int height = DIM.height > 720 ? 720 : DIM.height;
        super.setMaximumSize(new Dimension(width, height));
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        super.setPreferredSize(DIM);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        super.setSize(WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(WIDTH, HEIGHT);
    }

    @Override
    public void setSize(Dimension DIM) {
        super.setSize(DIM);
        this.calcInnerBounds();
        this.init(DIM.width, DIM.height);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        super.setBounds(BOUNDS);
        this.calcInnerBounds();
        this.init(BOUNDS.width, BOUNDS.height);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        super.setBounds(X, Y, WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(WIDTH, HEIGHT);
    }

    private BufferedImage create_SPARK_LINE_BACKGROUND_Image(int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Point2D.Double BACKGROUND_START = new Point2D.Double(0.0, 0.0);
        Point2D.Double BACKGROUND_STOP = new Point2D.Double(0.0, IMAGE_HEIGHT);
        if (BACKGROUND_START.equals(BACKGROUND_STOP)) {
            ((Point2D)BACKGROUND_STOP).setLocation(0.0, ((Point2D)BACKGROUND_START).getY() + 1.0);
        }
        float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] BACKGROUND_COLORS = new Color[]{new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint BACKGROUND_GRADIENT = new LinearGradientPaint(BACKGROUND_START, BACKGROUND_STOP, BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
        double BACKGROUND_CORNER_RADIUS = WIDTH > HEIGHT ? (double)HEIGHT * 0.12 : (double)WIDTH * 0.12;
        RoundRectangle2D.Double BACKGROUND = new RoundRectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT, BACKGROUND_CORNER_RADIUS, BACKGROUND_CORNER_RADIUS);
        G2.setPaint(BACKGROUND_GRADIENT);
        G2.fill(BACKGROUND);
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, 1.0);
        Point2D.Double FOREGROUND_STOP = new Point2D.Double(0.0, IMAGE_HEIGHT - 1);
        if (FOREGROUND_START.equals(FOREGROUND_STOP)) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{this.sparkLineColor.GRADIENT_START_COLOR, this.sparkLineColor.GRADIENT_FRACTION1_COLOR, this.sparkLineColor.GRADIENT_FRACTION2_COLOR, this.sparkLineColor.GRADIENT_FRACTION3_COLOR, this.sparkLineColor.GRADIENT_STOP_COLOR};
        if (this.customSparkLineColor != null && this.sparkLineColor == LcdColor.CUSTOM) {
            G2.setPaint(this.customSparkLineColor);
        } else {
            LinearGradientPaint FOREGROUND_GRADIENT = new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
            G2.setPaint(FOREGROUND_GRADIENT);
        }
        double FOREGROUND_CORNER_RADIUS = ((RoundRectangle2D)BACKGROUND).getArcWidth() - 1.0;
        RoundRectangle2D.Double FOREGROUND = new RoundRectangle2D.Double(1.0, 1.0, IMAGE_WIDTH - 2, IMAGE_HEIGHT - 2, FOREGROUND_CORNER_RADIUS, FOREGROUND_CORNER_RADIUS);
        G2.fill(FOREGROUND);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage createSparkLineImage(int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        if (!this.pointList.isEmpty()) {
            G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath SPARK_LINE = new GeneralPath();
            GeneralPath SPARK_LINE_FILLED = new GeneralPath();
            SPARK_LINE_FILLED.moveTo(this.pointList.get(0).getX(), this.baseLineY);
            SPARK_LINE.moveTo(this.pointList.get(0).getX(), (double)HEIGHT - this.pointList.get(0).getY());
            SPARK_LINE_FILLED.lineTo(this.pointList.get(0).getX(), (double)HEIGHT - this.pointList.get(0).getY());
            for (Point2D point : this.pointList) {
                SPARK_LINE.lineTo(point.getX(), (double)HEIGHT - point.getY());
                SPARK_LINE_FILLED.lineTo(point.getX(), (double)HEIGHT - point.getY());
            }
            SPARK_LINE_FILLED.lineTo(this.pointList.get(this.pointList.size() - 1).getX(), this.baseLineY);
            SPARK_LINE_FILLED.closePath();
            G2.setStroke(new BasicStroke(this.lineWidth, 1, 0));
            if (this.filled) {
                float baseLineFraction;
                Point2D.Double START_POINT = new Point2D.Double(0.0, this.INNER_BOUNDS.y);
                Point2D.Double END_POINT = new Point2D.Double(0.0, this.INNER_BOUNDS.y + this.INNER_BOUNDS.height);
                if (START_POINT.equals(END_POINT)) {
                    ((Point2D)END_POINT).setLocation(0.0, ((Point2D)START_POINT).getY() + 1.0);
                }
                if ((baseLineFraction = (float)(this.baseLineY / (double)this.INNER_BOUNDS.height)) < 0.0f || baseLineFraction > 1.0f) {
                    baseLineFraction = 0.5f;
                }
                if (START_POINT.distance(END_POINT) != 0.0) {
                    float[] fractions = new float[]{0.0f, baseLineFraction, 1.0f};
                    Color[] COLORS = this.areaFill == ColorDef.CUSTOM ? new Color[]{this.customAreaFillTop, this.customAreaFillBottom, this.customAreaFillTop} : new Color[]{UTIL.setAlpha(this.areaFill.LIGHT, 0.75f), UTIL.setAlpha(this.areaFill.DARK, 0.0f), UTIL.setAlpha(this.areaFill.LIGHT, 0.75f)};
                    LinearGradientPaint SPARK_LINE_GRADIENT = new LinearGradientPaint(START_POINT, END_POINT, fractions, COLORS);
                    G2.setPaint(SPARK_LINE_GRADIENT);
                    G2.fill(SPARK_LINE_FILLED);
                }
            } else if (this.lineShadowVisible) {
                G2.translate(1, 1);
                G2.setColor(new Color(0));
                G2.draw(SPARK_LINE);
                G2.translate(-1, -1);
            }
            G2.setColor(this.lineColor);
            G2.draw(SPARK_LINE);
            if (this.startStopIndicatorVisible) {
                G2.drawImage((Image)this.startIndicatorImage, (int)this.pointList.get(0).getX() - this.startIndicatorImage.getWidth() / 2, HEIGHT - (int)this.pointList.get(0).getY() - this.startIndicatorImage.getHeight() / 2, null);
                G2.drawImage((Image)this.stopIndicatorImage, (int)this.pointList.get(this.pointList.size() - 1).getX() - this.stopIndicatorImage.getWidth() / 2, HEIGHT - (int)this.pointList.get(this.pointList.size() - 1).getY() - this.stopIndicatorImage.getHeight() / 2, null);
            }
            if (this.hiLoIndicatorVisible) {
                if (this.loIndex < this.pointList.size()) {
                    G2.drawImage((Image)this.loIndicatorImage, (int)this.pointList.get(this.loIndex).getX() - this.loIndicatorImage.getWidth() / 2, HEIGHT - (int)this.pointList.get(this.loIndex).getY() - this.loIndicatorImage.getHeight() / 2, null);
                }
                if (this.hiIndex < this.pointList.size()) {
                    G2.drawImage((Image)this.hiIndicatorImage, (int)this.pointList.get(this.hiIndex).getX() - this.hiIndicatorImage.getWidth() / 2, HEIGHT - (int)this.pointList.get(this.hiIndex).getY() - this.hiIndicatorImage.getHeight() / 2, null);
                }
            }
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_HI_INDICATOR_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        int indicatorSize = (int)(0.015 * (double)WIDTH);
        if (indicatorSize < 4) {
            indicatorSize = 4;
        }
        if (indicatorSize > 8) {
            indicatorSize = 8;
        }
        BufferedImage IMAGE = UTIL.createImage(indicatorSize, indicatorSize, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath THRESHOLD_TRIANGLE = new GeneralPath();
        THRESHOLD_TRIANGLE.setWindingRule(0);
        THRESHOLD_TRIANGLE.moveTo((double)IMAGE_WIDTH * 0.5, 0.0);
        THRESHOLD_TRIANGLE.lineTo(0.0f, IMAGE_HEIGHT);
        THRESHOLD_TRIANGLE.lineTo(IMAGE_WIDTH, IMAGE_HEIGHT);
        THRESHOLD_TRIANGLE.lineTo((double)IMAGE_WIDTH * 0.5, 0.0);
        THRESHOLD_TRIANGLE.closePath();
        Point2D.Double THRESHOLD_TRIANGLE_START = new Point2D.Double(0.0, THRESHOLD_TRIANGLE.getBounds2D().getMinY());
        Point2D.Double THRESHOLD_TRIANGLE_STOP = new Point2D.Double(0.0, THRESHOLD_TRIANGLE.getBounds2D().getMaxY());
        float[] THRESHOLD_TRIANGLE_FRACTIONS = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] THRESHOLD_TRIANGLE_COLORS = new Color[]{new Color(82, 0, 0, 255), new Color(252, 29, 0, 255), new Color(252, 29, 0, 255), new Color(82, 0, 0, 255)};
        LinearGradientPaint THRESHOLD_TRIANGLE_GRADIENT = new LinearGradientPaint(THRESHOLD_TRIANGLE_START, THRESHOLD_TRIANGLE_STOP, THRESHOLD_TRIANGLE_FRACTIONS, THRESHOLD_TRIANGLE_COLORS);
        G2.setPaint(THRESHOLD_TRIANGLE_GRADIENT);
        G2.fill(THRESHOLD_TRIANGLE);
        G2.setColor(Color.RED);
        G2.setStroke(new BasicStroke(1.0f, 0, 0));
        G2.draw(THRESHOLD_TRIANGLE);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_LO_INDICATOR_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        int indicatorSize = (int)(0.015 * (double)WIDTH);
        if (indicatorSize < 4) {
            indicatorSize = 4;
        }
        if (indicatorSize > 8) {
            indicatorSize = 8;
        }
        BufferedImage IMAGE = UTIL.createImage(indicatorSize, indicatorSize, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath THRESHOLD_TRIANGLE = new GeneralPath();
        THRESHOLD_TRIANGLE.setWindingRule(0);
        THRESHOLD_TRIANGLE.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT);
        THRESHOLD_TRIANGLE.lineTo(0.0f, 0.0f);
        THRESHOLD_TRIANGLE.lineTo(IMAGE_WIDTH, 0.0f);
        THRESHOLD_TRIANGLE.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT);
        THRESHOLD_TRIANGLE.closePath();
        Point2D.Double THRESHOLD_TRIANGLE_START = new Point2D.Double(0.0, THRESHOLD_TRIANGLE.getBounds2D().getMaxY());
        Point2D.Double THRESHOLD_TRIANGLE_STOP = new Point2D.Double(0.0, THRESHOLD_TRIANGLE.getBounds2D().getMinY());
        float[] THRESHOLD_TRIANGLE_FRACTIONS = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] THRESHOLD_TRIANGLE_COLORS = new Color[]{new Color(0, 0, 72, 255), new Color(0, 29, 255, 255), new Color(0, 29, 255, 255), new Color(0, 0, 72, 255)};
        LinearGradientPaint THRESHOLD_TRIANGLE_GRADIENT = new LinearGradientPaint(THRESHOLD_TRIANGLE_START, THRESHOLD_TRIANGLE_STOP, THRESHOLD_TRIANGLE_FRACTIONS, THRESHOLD_TRIANGLE_COLORS);
        G2.setPaint(THRESHOLD_TRIANGLE_GRADIENT);
        G2.fill(THRESHOLD_TRIANGLE);
        G2.setColor(new Color(7679));
        G2.setStroke(new BasicStroke(1.0f, 0, 0));
        G2.draw(THRESHOLD_TRIANGLE);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_START_STOP_INDICATOR_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        int indicatorSize = (int)(0.015 * (double)WIDTH);
        if (indicatorSize < 4) {
            indicatorSize = 4;
        }
        if (indicatorSize > 8) {
            indicatorSize = 8;
        }
        BufferedImage IMAGE = UTIL.createImage(indicatorSize, indicatorSize, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double ELLIPSE = new Ellipse2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT);
        Point2D.Double ELLIPSE_CENTER = new Point2D.Double(0.42857142857142855 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT);
        float[] ELLIPSE_FRACTIONS = new float[]{0.0f, 0.01f, 0.99f, 1.0f};
        Color[] ELLIPSE_COLORS = new Color[]{new Color(204, 204, 204, 255), new Color(204, 204, 204, 255), new Color(51, 51, 51, 255), new Color(51, 51, 51, 255)};
        RadialGradientPaint ELLIPSE_GRADIENT = new RadialGradientPaint(ELLIPSE_CENTER, (float)(0.5 * (double)IMAGE_WIDTH), ELLIPSE_FRACTIONS, ELLIPSE_COLORS);
        G2.setPaint(ELLIPSE_GRADIENT);
        G2.fill(ELLIPSE);
        G2.dispose();
        return IMAGE;
    }

    private void createInitialImages() {
        this.recreateImages = true;
    }

    private void recreateAllImages() {
        this.recreateImages = true;
    }

    @Override
    public String toString() {
        return "Sparkline";
    }
}

