/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;

public class Section {
    private double start;
    private double stop;
    private Color color;
    private Color transparentColor;
    private Color highlightColor;
    private Color transparentHighlightColor;
    private Paint paint;
    private Area sectionArea;
    private Arc2D filledArea;

    public Section() {
        this(-1.0, -1.0, Color.RED, null, null);
    }

    public Section(double START, double STOP, Color COLOR) {
        this(START, STOP, COLOR, null, null);
    }

    public Section(double START, double STOP, Color COLOR, Color HIGHLIGHT_COLOR) {
        this(START, STOP, COLOR, HIGHLIGHT_COLOR, null, null);
    }

    public Section(double START, double STOP, Color COLOR, Arc2D FILLED_AREA) {
        this(START, STOP, COLOR, null, FILLED_AREA);
    }

    public Section(double START, double STOP, Color COLOR, Area SECTION_AREA, Arc2D FILLED_AREA) {
        this(START, STOP, COLOR, COLOR.brighter().brighter(), SECTION_AREA, FILLED_AREA);
    }

    public Section(double START, double STOP, Color COLOR, Color HIGHLIGHT_COLOR, Area SECTION_AREA, Arc2D FILLED_AREA) {
        this.start = START;
        this.stop = STOP;
        this.color = COLOR;
        this.transparentColor = Util.INSTANCE.setAlpha(COLOR, 0.25f);
        this.highlightColor = HIGHLIGHT_COLOR;
        this.transparentHighlightColor = Util.INSTANCE.setAlpha(HIGHLIGHT_COLOR, 0.5f);
        this.sectionArea = SECTION_AREA;
        this.filledArea = FILLED_AREA;
        this.paint = COLOR;
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double START) {
        this.start = START;
    }

    public double getStop() {
        return this.stop;
    }

    public void setStop(double STOP) {
        this.stop = STOP;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public void setColor(Color COLOR) {
        this.color = COLOR;
        this.transparentColor = Util.INSTANCE.setAlpha(COLOR, 0.25f);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getTransparentHighlightColor() {
        return this.transparentHighlightColor;
    }

    public void setHighlightColor(Color HIGHLIGHT_COLOR) {
        this.highlightColor = HIGHLIGHT_COLOR;
        this.transparentHighlightColor = Util.INSTANCE.setAlpha(HIGHLIGHT_COLOR, 0.5f);
    }

    public Area getSectionArea() {
        return this.sectionArea;
    }

    public void setSectionArea(Area SECTION_AREA) {
        this.sectionArea = SECTION_AREA;
    }

    public Arc2D getFilledArea() {
        return this.filledArea;
    }

    public void setFilledArea(Arc2D FILLED_AREA) {
        this.filledArea = FILLED_AREA;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint PAINT) {
        this.paint = PAINT;
    }

    public boolean contains(double VALUE) {
        return Double.compare(VALUE, this.start) >= 0 && Double.compare(VALUE, this.stop) <= 0;
    }

    public String toString() {
        return "Section";
    }
}

