/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.rusefi.core.FileUtil;
import com.rusefi.core.Sensor;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public interface ISensorHolder {
    default public void grabSensorValues(byte[] response) {
        for (Sensor sensor : Sensor.values()) {
            if (sensor.getType() == null) continue;
            ByteBuffer bb = ISensorHolder.getByteBufferForSensor(response, sensor);
            double rawValue = sensor.getValueForChannel(bb);
            double scaledValue = rawValue * sensor.getScale();
            this.setValue(scaledValue, sensor);
        }
    }

    @Deprecated
    @NotNull
    public static ByteBuffer getByteBufferForSensor(byte[] response, Sensor sensor) {
        return ISensorHolder.getByteBuffer(response, sensor.toString(), sensor.getOffset());
    }

    @NotNull
    public static ByteBuffer getByteBuffer(byte[] response, String message, int fieldOffset) {
        int offset = fieldOffset + 1;
        int size = 4;
        if (offset + size > response.length) {
            throw new IllegalArgumentException(message + String.format(" but %d+%d in %d", offset, size, response.length));
        }
        return FileUtil.littleEndianWrap(response, offset, size);
    }

    public double getValue(Sensor var1);

    public boolean setValue(double var1, Sensor var3);
}

