/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini.field;

import com.opensr5.ConfigurationImage;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.rusefi.config.Field;
import com.rusefi.config.FieldType;
import com.rusefi.tune.xml.Constant;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class ArrayIniField
extends IniField {
    private final FieldType type;
    private final int cols;
    private final int rows;
    private final double multiplier;
    @Nullable
    private final String min;
    @Nullable
    private final String max;
    private final String digits;

    public ArrayIniField(String name, int offset, FieldType type, int cols, int rows, String unit, double multiplier, String min, String max, String digits) {
        super(name, offset);
        this.type = type;
        this.cols = cols;
        this.rows = rows;
        this.multiplier = multiplier;
        this.min = min;
        this.max = max;
        this.digits = digits;
    }

    public FieldType getType() {
        return this.type;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public String getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }

    @Override
    public String getDigits() {
        return this.digits;
    }

    @Override
    public int getSize() {
        return this.type.getStorageSize() * this.cols * this.rows;
    }

    public String formatValue(String[][] values) {
        StringBuilder sb = new StringBuilder();
        for (String[] row : values) {
            sb.append("\n        ");
            for (String element : row) {
                sb.append(' ');
                sb.append(element);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String getValue(ConfigurationImage image) {
        String[][] values = new String[this.rows][this.cols];
        for (int rowIndex = 0; rowIndex < this.rows; ++rowIndex) {
            for (int colIndex = 0; colIndex < this.cols; ++colIndex) {
                Field f = new Field(this.getName() + "_" + colIndex, this.getOffset(rowIndex, colIndex), this.getType());
                values[rowIndex][colIndex] = f.getAnyValue(image, this.multiplier);
            }
        }
        return this.formatValue(values);
    }

    private int getOffset(int rowIndex, int colIndex) {
        return this.getOffset() + (rowIndex * this.cols + colIndex) * this.getType().getStorageSize();
    }

    public String[][] getValues(String value) {
        String[] values = value.trim().split("\\s+");
        if (values.length != this.rows * this.cols) {
            throw new IllegalStateException(values.length + " values while expecting " + this.getRows() + " by " + this.getCols() + " total " + this.rows * this.cols);
        }
        String[][] result = new String[this.rows][this.cols];
        for (int i = 0; i < values.length; ++i) {
            int rowIndex = i / this.cols;
            int colIndex = i % this.cols;
            result[rowIndex][colIndex] = values[i];
        }
        return result;
    }

    @Override
    public void setValue(ConfigurationImage image, Constant constant) {
        String[][] values = this.getValues(constant.getValue());
        for (int rowIndex = 0; rowIndex < values.length; ++rowIndex) {
            String[] row = values[rowIndex];
            for (int colIndex = 0; colIndex < row.length; ++colIndex) {
                ByteBuffer wrapped = image.getByteBuffer(this.getOffset(rowIndex, colIndex), this.type.getStorageSize());
                ScalarIniField.setValue(wrapped, this.type, values[rowIndex][colIndex], -1, this.multiplier);
            }
        }
    }

    public String toString() {
        return "ArrayIniField{name=" + this.getName() + ", offset=" + this.getOffset() + ", type=" + (Object)((Object)this.type) + ", cols=" + this.cols + ", rows=" + this.rows + '}';
    }

    public static IniField parse(LinkedList<String> list) {
        int rows;
        int cols;
        String name = list.get(0);
        FieldType type = FieldType.parseTs(list.get(2));
        int offset = Integer.parseInt(list.get(3));
        String size = list.get(4);
        String unit = list.size() > 5 ? list.get(5) : "error";
        String min = list.size() > 8 ? list.get(8) : null;
        String max = list.size() > 9 ? list.get(9) : null;
        String digits = list.size() > 10 ? list.get(10) : "0";
        double multiplier = IniField.parseDouble(list.size() > 6 ? list.get(6) : "1");
        String[] dimentions = (size = size.replaceAll("[\\]\\[x]", " ").trim()).split(" ");
        if (dimentions.length == 1) {
            cols = 1;
            rows = Integer.parseInt(dimentions[0]);
        } else if (dimentions.length == 2) {
            cols = Integer.parseInt(dimentions[0]);
            rows = Integer.parseInt(dimentions[1]);
        } else {
            throw new IllegalStateException("Unexpected " + size);
        }
        return new ArrayIniField(name, offset, type, cols, rows, unit, multiplier, min, max, digits);
    }
}

