/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.IniField;
import com.rusefi.core.Pair;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.ComposedIniFieldMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IniFieldsAnalyzer {
    private static final Logging log = Logging.getLogging(IniFieldsAnalyzer.class);

    public static List<Pair<IniField, Constant>> findValuesToUpdate(IniFileModel prevIni, Map<String, Constant> prevValues, IniFileModel newIni, Map<String, Constant> newValues, UpdateOperationCallbacks callbacks) {
        ArrayList<Pair<IniField, Constant>> result = new ArrayList<Pair<IniField, Constant>>();
        Map<String, IniField> prevIniFields = prevIni.getAllIniFields();
        Map<String, IniField> newIniFields = newIni.getAllIniFields();
        for (Map.Entry<String, IniField> prevFieldEntry : prevIniFields.entrySet()) {
            String prevFieldName = prevFieldEntry.getKey();
            IniField newField = newIniFields.get(prevFieldName);
            if (newField == null) continue;
            Constant prevValue = prevValues.get(prevFieldName);
            Constant newValue = newValues.get(prevFieldName);
            if (prevValue != null && newValue != null) {
                if (Objects.equals(prevValue.getValue(), newValue.getValue())) continue;
                if (!Objects.equals(prevValue.getName(), newValue.getName())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its name is updated: `%s` -> `%s`", prevFieldName, prevValue.getName(), newValue.getName()));
                    continue;
                }
                if (!Objects.equals(prevValue.getUnits(), newValue.getUnits())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its units are updated: `%s` -> `%s`", prevFieldName, prevValue.getUnits(), newValue.getUnits()));
                    continue;
                }
                if (!Objects.equals(prevValue.getDigits(), newValue.getDigits())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its digits are updated: `%s` -> `%s`", prevFieldName, prevValue.getDigits(), newValue.getDigits()));
                    continue;
                }
                if (!Objects.equals(prevValue.getCols(), newValue.getCols())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its column count is updated: `%s` -> `%s`", prevFieldName, prevValue.getCols(), newValue.getCols()));
                    continue;
                }
                if (!Objects.equals(prevValue.getRows(), newValue.getRows())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its row count is updated: `%s` -> `%s`", prevFieldName, prevValue.getRows(), newValue.getRows()));
                    continue;
                }
                Optional<String> migratedValue = ComposedIniFieldMigrator.INSTANCE.tryMigrateValue(prevFieldEntry.getValue(), newField, prevValue.getValue(), callbacks);
                if (migratedValue.isPresent()) {
                    String valueToRestore = migratedValue.get();
                    if (!valueToRestore.equals(newValue.getValue())) {
                        log.info(String.format("Field `%s` is going to be restored: `%s` -> `%s`", prevFieldName, prevValue.getValue(), newValue.getValue()));
                        result.add(new Pair<IniField, Constant>(newField, newValue.cloneWithValue(valueToRestore)));
                        continue;
                    }
                    callbacks.logLine(String.format("We aren't going to restore field `%s`: it looks like its value is just renamed: `%s` -> `%s`", prevFieldName, prevValue.getValue(), newValue.getValue()));
                    continue;
                }
                log.warn(String.format("Field `%s` cannot be updated: `%s` -> `%s`", prevFieldName, prevFieldEntry.getValue(), newField));
                continue;
            }
            log.info(String.format("Field `%s` is missed in new .ini file", prevFieldName));
        }
        return result;
    }
}

