/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.ConsoleUI;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.putgemin.VerticalFlowLayout;

public class LogDownloader {
    private static final String LS_RESPONSE = "ls_result";
    private static final String LS_ENTRY_PREFIX = "logfile";
    private static final String DELETE = "[delete]";
    private static final String DOWNLOAD = "[download]";
    private final JPanel content = new JPanel(new BorderLayout());
    private final JPanel logFiles = new JPanel(new VerticalFlowLayout());
    private final Timer timer = new Timer(3000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            LogDownloader.this.listDirectory();
        }
    });
    private final UIContext uiContext;

    public LogDownloader(UIContext uiContext) {
        this.uiContext = uiContext;
        UiUtils.showLoadingMessage(this.content);
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                if (message.startsWith(LogDownloader.LS_RESPONSE)) {
                    LogDownloader.this.resetLogsList();
                } else if (message.startsWith(LogDownloader.LS_ENTRY_PREFIX)) {
                    long size;
                    int colonIndex = (message = message.substring(LogDownloader.LS_ENTRY_PREFIX.length())).indexOf(58);
                    if (colonIndex == -1) {
                        return;
                    }
                    try {
                        size = Integer.parseInt(message.substring(0, colonIndex));
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                    JPanel logFileEntry = LogDownloader.this.createFilePanel(message.substring(colonIndex + 1), size);
                    LogDownloader.this.logFiles.add(logFileEntry);
                    AutoupdateUtil.trueLayout(LogDownloader.this.logFiles.getParent());
                }
            }
        });
    }

    @NotNull
    private JPanel createFilePanel(final String name, long size) {
        JLabel label = new JLabel(name + " [" + size + " bytes]");
        JPanel logFileEntry = new JPanel(new FlowLayout());
        logFileEntry.add(label);
        JButton removeFile = new JButton(DELETE);
        removeFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = JOptionPane.showConfirmDialog(ConsoleUI.getFrame(), "Do you really want to delete " + name + "?", UIManager.getString("OptionPane.titleText"), 0);
                if (i == 0) {
                    LogDownloader.this.uiContext.getCommandQueue().write("del " + name);
                    LogDownloader.this.timer.restart();
                }
            }
        });
        JButton downloadFile = new JButton(DOWNLOAD);
        downloadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogDownloader.this.uiContext.getCommandQueue().write("get_file 0 " + name);
            }
        });
        logFileEntry.add(removeFile);
        logFileEntry.add(downloadFile);
        return logFileEntry;
    }

    private void resetLogsList() {
        this.logFiles.removeAll();
    }

    public JPanel getContent() {
        return this.content;
    }

    public void showContent() {
        this.content.removeAll();
        JButton refresh = new JButton("Refresh");
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogDownloader.this.listDirectory();
            }
        });
        this.content.add((Component)refresh, "North");
        this.content.add((Component)this.logFiles, "Center");
        this.listDirectory();
    }

    private void listDirectory() {
    }
}

