/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan.util;

import java.nio.ByteBuffer;
import tel.schich.javacan.JavaCAN;
import tel.schich.javacan.platform.UnsupportedPlatformException;

public abstract class BufferHelper {
    public static final int LONG_SIZE;
    private static final PlatformLongAccessor PLATFORM_LONG_ACCESSOR;

    private BufferHelper() {
    }

    public static boolean equals(ByteBuffer bufferA, int baseA, int sizeA, ByteBuffer bufferB, int baseB, int sizeB) {
        if (sizeA != sizeB) {
            return false;
        }
        for (int i = 0; i < sizeA; ++i) {
            if (bufferA.get(baseA + i) == bufferB.get(baseB + i)) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(ByteBuffer buffer, int base, int size) {
        int result = 1;
        for (int i = 0; i < size; ++i) {
            result = 31 * result + buffer.get(base + i);
        }
        return result;
    }

    public static long getPlatformLong(ByteBuffer buffer, int offset) {
        return PLATFORM_LONG_ACCESSOR.read(buffer, offset);
    }

    public static int putPlatformLong(ByteBuffer buffer, int offset, long value) {
        return PLATFORM_LONG_ACCESSOR.write(buffer, offset, value);
    }

    private static native int getLongSize();

    static {
        JavaCAN.initialize();
        LONG_SIZE = BufferHelper.getLongSize();
        switch (LONG_SIZE) {
            case 4: {
                PLATFORM_LONG_ACCESSOR = new IntPlatformLongAccessor();
                break;
            }
            case 8: {
                PLATFORM_LONG_ACCESSOR = new LongPlatformLongAccessor();
                break;
            }
            default: {
                throw new UnsupportedPlatformException();
            }
        }
    }

    private static final class IntPlatformLongAccessor
    implements PlatformLongAccessor {
        private IntPlatformLongAccessor() {
        }

        @Override
        public long read(ByteBuffer buf, int offset) {
            return buf.getInt(offset);
        }

        @Override
        public int write(ByteBuffer buf, int offset, long value) {
            buf.putInt(offset, (int)value);
            return 4;
        }
    }

    private static final class LongPlatformLongAccessor
    implements PlatformLongAccessor {
        private LongPlatformLongAccessor() {
        }

        @Override
        public long read(ByteBuffer buf, int offset) {
            return buf.getLong(offset);
        }

        @Override
        public int write(ByteBuffer buf, int offset, long value) {
            buf.putLong(offset, value);
            return 8;
        }
    }

    private static interface PlatformLongAccessor {
        public long read(ByteBuffer var1, int var2);

        public int write(ByteBuffer var1, int var2, long var3);
    }
}

