/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.preferences.storage;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Node {
    private String prefix;
    private Map<String, Object> config = new HashMap<String, Object>();

    public Node() {
    }

    protected Node(String prefix, Map<String, Object> parent) {
        this.prefix = prefix;
        if (parent.containsKey(prefix)) {
            Node existing = (Node)parent.get(prefix);
            this.config = existing.getConfig();
        } else {
            parent.put(prefix, this);
        }
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    @NotNull
    public Node getChild(String name) {
        Node child = (Node)this.config.get(name);
        if (child == null) {
            child = new Node(name, this.config);
        }
        return child;
    }

    public int getIntProperty(String key, int defaultValue) {
        try {
            String value = (String)this.config.get(key);
            return Integer.parseInt(value);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public boolean getBoolProperty(String key) {
        return this.getBoolProperty(key, false);
    }

    public boolean getBoolProperty(String key, boolean defaultValue) {
        String value = (String)this.config.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public void setProperty(String key, String value) {
        this.config.put(key, value);
    }

    public void setProperty(String key, int value) {
        this.config.put(key, "" + value);
    }

    public void setProperty(String key, boolean value) {
        this.config.put(key, "" + value);
    }

    public void setBoolProperty(String key, boolean b) {
        this.setProperty(key, "" + b);
    }

    @Nullable
    public String getProperty(String key, @Nullable String defaultValue) {
        String value = (String)this.config.get(key);
        return value == null ? defaultValue : value;
    }

    @NotNull
    public String getProperty(String key) {
        return this.getProperty(key, "");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public String toString() {
        return "Node{prefix='" + this.prefix + '\'' + '}';
    }

    public void setProperty(String key, double value) {
        this.setProperty(key, Double.toString(value));
    }

    public double getDoubleProperty(String key, double defaultValue) {
        String value = this.getProperty(key);
        if (Node.isNumeric(value)) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }
}

