/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.config.FieldType;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.TuneMigrator;
import com.rusefi.maintenance.migration.VeRpmBinsIniFieldMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Optional;

public enum VeTableExtensionMigrator implements TuneMigrator
{
    INSTANCE;

    static final String VE_TABLE_FIELD_NAME = "veTable";
    static final String VE_RPM_BINS_FIELD_NAME = "veRpmBins";
    private static final FieldType VE_TABLE_TYPE;
    static final int VE_TABLE_ROWS = 16;
    static final int OLD_VE_TABLE_COLS = 16;
    static final int NEW_VE_TABLE_COLS = 24;

    @Override
    public void migrateTune(TuneMigrationContext context) {
        this.migrateVeTable(context);
        this.migrateVeRpmBinsTable(context);
    }

    private void migrateVeTable(TuneMigrationContext context) {
        Constant prevValue = context.getPrevTune().getConstantsAsMap().get(VE_TABLE_FIELD_NAME);
        if (prevValue != null) {
            Optional<IniField> prevField = context.getPrevIniFile().findIniField(VE_TABLE_FIELD_NAME);
            if (!prevField.isPresent()) {
                context.getCallbacks().logLine(String.format("WARNING!!! Missed `%s` ini field in previous .ini file.", VE_TABLE_FIELD_NAME));
                return;
            }
            Optional<IniField> updatedField = context.getUpdatedIniFile().findIniField(VE_TABLE_FIELD_NAME);
            if (!updatedField.isPresent()) {
                context.getCallbacks().logLine(String.format("WARNING!!! Missed `%s` ini field in updated .ini file.", VE_TABLE_FIELD_NAME));
                return;
            }
            Optional<ArrayIniField> prevArrayIniField = VeTableExtensionMigrator.getValidatedVeTableArrayIniField(prevField.get(), context.getCallbacks());
            Optional<ArrayIniField> updatedArrayIniField = VeTableExtensionMigrator.getValidatedVeTableArrayIniField(updatedField.get(), context.getCallbacks());
            if (prevArrayIniField.isPresent() && updatedArrayIniField.isPresent()) {
                Optional<String> migratedValue;
                ArrayIniField prevVeTableField = prevArrayIniField.get();
                ArrayIniField updatedVeTableField = updatedArrayIniField.get();
                if (prevVeTableField.getCols() == 16 && updatedVeTableField.getCols() == 24 && (migratedValue = this.tryMigrateVeTable(prevVeTableField, updatedVeTableField, prevValue.getValue(), context.getCallbacks())).isPresent()) {
                    context.addMigration(VE_TABLE_FIELD_NAME, new Constant(VE_TABLE_FIELD_NAME, updatedVeTableField.getUnits(), migratedValue.get(), updatedVeTableField.getDigits(), Integer.toString(updatedVeTableField.getRows()), Integer.toString(updatedVeTableField.getCols())));
                }
            }
        }
    }

    private void migrateVeRpmBinsTable(TuneMigrationContext context) {
        Constant prevValue = context.getPrevTune().getConstantsAsMap().get(VE_RPM_BINS_FIELD_NAME);
        if (prevValue != null) {
            Optional<IniField> prevField = context.getPrevIniFile().findIniField(VE_RPM_BINS_FIELD_NAME);
            if (!prevField.isPresent()) {
                context.getCallbacks().logLine(String.format("WARNING!!! Missed `%s` ini field in previous .ini file.", VE_RPM_BINS_FIELD_NAME));
                return;
            }
            Optional<IniField> updatedField = context.getUpdatedIniFile().findIniField(VE_RPM_BINS_FIELD_NAME);
            if (!updatedField.isPresent()) {
                context.getCallbacks().logLine(String.format("WARNING!!! Missed `%s` ini field in updated .ini file.", VE_RPM_BINS_FIELD_NAME));
                return;
            }
            ArrayIniField updatedVeRpmBinsField = (ArrayIniField)updatedField.get();
            Optional<String> migratedValue = VeRpmBinsIniFieldMigrator.INSTANCE.tryMigrateVeRpmBins(prevField.get(), updatedVeRpmBinsField, prevValue.getValue(), context.getCallbacks());
            if (migratedValue.isPresent()) {
                context.addMigration(VE_RPM_BINS_FIELD_NAME, new Constant(VE_RPM_BINS_FIELD_NAME, updatedVeRpmBinsField.getUnits(), migratedValue.get(), updatedVeRpmBinsField.getDigits(), Integer.toString(updatedVeRpmBinsField.getRows()), Integer.toString(updatedVeRpmBinsField.getCols())));
            }
        }
    }

    private Optional<String> tryMigrateVeTable(IniField prevField, IniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<String> result = Optional.empty();
        Optional<ArrayIniField> prevVeTableValidatedField = VeTableExtensionMigrator.getValidatedVeTableArrayIniField(prevField, callbacks);
        Optional<ArrayIniField> newVeTableValidatedField = VeTableExtensionMigrator.getValidatedVeTableArrayIniField(newField, callbacks);
        if (prevVeTableValidatedField.isPresent() && newVeTableValidatedField.isPresent()) {
            ArrayIniField prevVeTableField = prevVeTableValidatedField.get();
            ArrayIniField newVeTableField = newVeTableValidatedField.get();
            int prevVeTableFieldCols = prevVeTableField.getCols();
            int newVeTableFieldCols = newVeTableField.getCols();
            if (prevVeTableFieldCols == 16 && newVeTableFieldCols == 24) {
                String[][] prevValues = prevVeTableField.getValues(prevValue);
                String[][] newValues = new String[16][24];
                for (int rowIdx = 0; rowIdx < 16; ++rowIdx) {
                    int colIdx;
                    for (colIdx = 0; colIdx < 16; ++colIdx) {
                        newValues[rowIdx][colIdx] = prevValues[rowIdx][colIdx];
                    }
                    for (colIdx = 16; colIdx < 24; ++colIdx) {
                        newValues[rowIdx][colIdx] = prevValues[rowIdx][15];
                    }
                }
                result = Optional.of(newVeTableField.formatValue(newValues));
            }
        }
        return result;
    }

    private static Optional<ArrayIniField> getValidatedVeTableArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `veTable` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != VE_TABLE_TYPE) {
            callbacks.logLine(String.format("WARNING! `veTable` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        if (arrayFieldRows != 16) {
            callbacks.logLine(String.format("WARNING! `veTable` ini-field is expected to contain %d rows instead of %d", 16, arrayFieldRows));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        switch (arrayFieldCols) {
            case 16: 
            case 24: {
                return Optional.of(arrayField);
            }
        }
        callbacks.logLine(String.format("WARNING! `veTable` ini-field is expected to contain %d or %d columns instead of %d", 16, 24, arrayFieldRows));
        return Optional.empty();
    }

    static {
        VE_TABLE_TYPE = FieldType.UINT16;
    }
}

