/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.tools.online;

import com.devexperts.logging.Logging;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class HttpUtil {
    private static final Logging log = Logging.getLogging(Logging.class);
    public static final String RUSEFI_PROXY_JSON_PROTOCOL = "http://";
    public static final int PROXY_JSON_API_HTTP_PORT = HttpUtil.getIntProperty("http.port", 8001);
    public static String RUSEFI_PROXY_HOSTNAME = System.getProperty("RUSEFI_PROXY_URL", "proxy.rusefi.com");
    public static String RUSEFI_ONLINE_JSON_API_PREFIX = "https://rusefi.com/online/api.php?method=";

    public static <T> T getJsonResponse(String responseString) throws ParseException {
        JSONParser parser = new JSONParser();
        return (T)parser.parse(responseString);
    }

    public static String getResponse(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        String responseString = EntityUtils.toString(entity, "UTF-8");
        log.info("responseString=" + responseString);
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeGet(String url) throws IOException {
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).setTcpNoDelay(true).build();
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultSocketConfig(socketConfig).build();
        log.info("GET " + url);
        HttpGet httpget = new HttpGet(url);
        try {
            CloseableHttpResponse httpResponse = httpclient.execute(httpget);
            String string = HttpUtil.getResponse(httpResponse);
            return string;
        }
        finally {
            httpget.releaseConnection();
        }
    }

    public static JSONObject parse(String jsonString) {
        JSONObject jsonObject;
        JSONParser parser = new JSONParser();
        try {
            jsonObject = (JSONObject)parser.parse(jsonString);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        return jsonObject;
    }

    public static int getIntProperty(String propertyName, int defaultValue) {
        return Integer.parseInt(System.getProperty(propertyName, Integer.toString(defaultValue)));
    }
}

