/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.DataBuffer;
import java.util.Arrays;

public class CyclicBuffer
implements DataBuffer {
    private final double[] values;
    private int size = 0;
    private int pointer = 0;

    public CyclicBuffer(int maxSize) {
        this.values = new double[maxSize];
    }

    @Override
    public void clear() {
        this.pointer = 0;
        this.size = 0;
    }

    @Override
    public void add(double value) {
        if (this.size < this.values.length) {
            ++this.size;
        }
        this.values[this.pointer] = value;
        ++this.pointer;
        if (this.pointer == this.values.length) {
            this.pointer = 0;
        }
    }

    public int getPointer() {
        return this.pointer;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public double[] getValues() {
        return Arrays.copyOfRange(this.values, 0, this.size);
    }

    public int getMaxSize() {
        return this.values.length;
    }

    public double get(int i) {
        if (this.size < 1) {
            throw new IllegalStateException("Size " + this.size);
        }
        while (i < 0) {
            i += this.size;
        }
        return this.values[i % this.size];
    }
}

