/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniMemberNotFound;
import com.opensr5.ini.field.IniField;
import com.rusefi.SerialPortScanner;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.BinaryProtocolExecutor;
import com.rusefi.panama.PanamaHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class OutputChannelsHelper {
    private static final Logging log = Logging.getLogging(OutputChannelsHelper.class);
    private static final String MCUSERIAL = PanamaHelper.MCUSERIAL;

    public static Optional<Integer> readMcuSerial(SerialPortScanner.PortResult ecuPort, UpdateOperationCallbacks callbacks) {
        return BinaryProtocolExecutor.executeWithSuspendedPortScanner(ecuPort.port, callbacks, binaryProtocol -> OutputChannelsHelper.readMcuSerial(binaryProtocol, callbacks), Optional.empty(), false);
    }

    private static Optional<Integer> readMcuSerial(BinaryProtocol binaryProtocol, UpdateOperationCallbacks callbacks) {
        IniField mcuSerialField;
        callbacks.logLine("Reading `" + MCUSERIAL + "` output channel...");
        try {
            mcuSerialField = PanamaHelper.getIniField(binaryProtocol);
        }
        catch (IniMemberNotFound e) {
            callbacks.logLine("Please update firmware to use this feature...");
            return Optional.empty();
        }
        AtomicInteger mcuSerial = new AtomicInteger();
        SensorCentral.getInstance().addListener(() -> mcuSerial.set(PanamaHelper.getMcuSerial(mcuSerialField)));
        if (binaryProtocol.requestOutputChannels()) {
            callbacks.logLine(String.format(PanamaHelper.MCUSERIAL + " is %d", mcuSerial.get()));
            return Optional.of(mcuSerial.get());
        }
        callbacks.logLine("Failed to request output channels...");
        return Optional.empty();
    }
}

