/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImageWithMeta;
import com.opensr5.io.ConfigurationImageFile;
import com.rusefi.SerialPortScanner;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.maintenance.jobs.UpdateCalibrationsJob;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class UpdateCalibrations {
    private static final Logging log = Logging.getLogging(UpdateCalibrations.class);
    private static final String BINARY_IMAGE_DEFAULT_DIRECTORY_PROPERTY_NAME = "binary_image_default_directory";
    private final SingleAsyncJobExecutor singleAsyncJobExecutor;
    private final JFileChooser calibrationsFileChooser = UpdateCalibrations.createConfigurationImageFileChooser();

    UpdateCalibrations(SingleAsyncJobExecutor singleAsyncJobExecutor) {
        this.singleAsyncJobExecutor = singleAsyncJobExecutor;
    }

    void updateCalibrationsAction(SerialPortScanner.PortResult port, JComponent parent) {
        int selectedOption = this.calibrationsFileChooser.showOpenDialog(parent);
        if (selectedOption == 0) {
            File selectedFile = this.calibrationsFileChooser.getSelectedFile();
            UpdateCalibrations.saveBinaryImageDefaultDirectory(selectedFile.getParent());
            try {
                ConfigurationImageWithMeta calibrationsImage = ConfigurationImageFile.readFromFile(selectedFile.getAbsolutePath());
                this.singleAsyncJobExecutor.startJob(new UpdateCalibrationsJob(port, calibrationsImage), parent);
            }
            catch (IOException e) {
                String errorMsg = String.format("Failed to load calibrations from file %s", selectedFile.getAbsolutePath());
                log.error(errorMsg, e);
                JOptionPane.showMessageDialog(parent, errorMsg, "Error", 0);
            }
        }
    }

    private static JFileChooser createConfigurationImageFileChooser() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileNameExtensionFilter("Calibrations files (.zip)", "zip"));
        String currentDirectory = UpdateCalibrations.loadBinaryImageDefaultDirectory();
        if (currentDirectory != null) {
            fc.setCurrentDirectory(new File(currentDirectory));
        }
        return fc;
    }

    private static void saveBinaryImageDefaultDirectory(String path) {
        PersistentConfiguration.getConfig().getRoot().setProperty(BINARY_IMAGE_DEFAULT_DIRECTORY_PROPERTY_NAME, path);
        PersistentConfiguration.getConfig().save();
    }

    private static String loadBinaryImageDefaultDirectory() {
        return PersistentConfiguration.getConfig().getRoot().getProperty(BINARY_IMAGE_DEFAULT_DIRECTORY_PROPERTY_NAME, "");
    }
}

