/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.util.Random;

public class BrushedMetalFilter
implements BufferedImageOp {
    private int radius;
    private float amount = 0.1f;
    private int color = -7829368;
    private float shine = 0.0f;
    private boolean monochrome = false;
    private Random randomNumbers;

    public BrushedMetalFilter() {
    }

    public BrushedMetalFilter(int COLOR, int RADIUS, float AMOUNT, boolean MONOCHROME, float SHINE) {
        this.color = COLOR;
        this.radius = RADIUS;
        this.amount = AMOUNT;
        this.monochrome = MONOCHROME;
        this.shine = SHINE;
    }

    @Override
    public BufferedImage filter(BufferedImage SOURCE, BufferedImage destination) {
        int WIDTH = SOURCE.getWidth();
        int HEIGHT = SOURCE.getHeight();
        if (destination == null) {
            destination = this.createCompatibleDestImage(SOURCE, null);
        }
        int[] IN_PIXELS = new int[WIDTH];
        int[] OUT_PIXELS = new int[WIDTH];
        this.randomNumbers = new Random(0L);
        int ALPHA = this.color & 0xFF000000;
        int RED = this.color >> 16 & 0xFF;
        int GREEN = this.color >> 8 & 0xFF;
        int BLUE = this.color & 0xFF;
        for (int y = 0; y < HEIGHT; ++y) {
            for (int x = 0; x < WIDTH; ++x) {
                int tr = RED;
                int tg = GREEN;
                int tb = BLUE;
                if (this.shine != 0.0f) {
                    int f = (int)((double)(255.0f * this.shine) * Math.sin((double)x / (double)WIDTH * Math.PI));
                    tr += f;
                    tg += f;
                    tb += f;
                }
                if (this.monochrome) {
                    int n = (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount);
                    IN_PIXELS[x] = ALPHA | BrushedMetalFilter.clamp(tr + n) << 16 | BrushedMetalFilter.clamp(tg + n) << 8 | BrushedMetalFilter.clamp(tb + n);
                    continue;
                }
                IN_PIXELS[x] = ALPHA | this.random(tr) << 16 | this.random(tg) << 8 | this.random(tb);
            }
            if (this.radius != 0) {
                this.blur(IN_PIXELS, OUT_PIXELS, WIDTH, this.radius);
                this.setRGB(destination, 0, y, WIDTH, 1, OUT_PIXELS);
                continue;
            }
            this.setRGB(destination, 0, y, WIDTH, 1, IN_PIXELS);
        }
        return destination;
    }

    private int random(int x) {
        if ((x += (int)(255.0f * (2.0f * this.randomNumbers.nextFloat() - 1.0f) * this.amount)) < 0) {
            x = 0;
        } else if (x > 255) {
            x = 255;
        }
        return x;
    }

    private static int clamp(int C) {
        int ret = C;
        if (C < 0) {
            ret = 0;
        }
        if (C > 255) {
            ret = 255;
        }
        return ret;
    }

    private static int mod(int a, int B) {
        int N;
        if ((a -= (N = a / B) * B) < 0) {
            return a + B;
        }
        return a;
    }

    public void blur(int[] IN, int[] OUT, int WIDTH, int RADIUS) {
        int WIDTH_MINUS_1 = WIDTH - 1;
        int R2 = 2 * RADIUS + 1;
        int tr = 0;
        int tg = 0;
        int tb = 0;
        for (int i = -RADIUS; i <= RADIUS; ++i) {
            int rgb = IN[BrushedMetalFilter.mod(i, WIDTH)];
            tr += rgb >> 16 & 0xFF;
            tg += rgb >> 8 & 0xFF;
            tb += rgb & 0xFF;
        }
        for (int x = 0; x < WIDTH; ++x) {
            int i2;
            OUT[x] = 0xFF000000 | tr / R2 << 16 | tg / R2 << 8 | tb / R2;
            int i1 = x + RADIUS + 1;
            if (i1 > WIDTH_MINUS_1) {
                i1 = BrushedMetalFilter.mod(i1, WIDTH);
            }
            if ((i2 = x - RADIUS) < 0) {
                i2 = BrushedMetalFilter.mod(i2, WIDTH);
            }
            int rgb1 = IN[i1];
            int rgb2 = IN[i2];
            tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
            tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
            tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
        }
    }

    public void setRadius(int RADIUS) {
        this.radius = RADIUS;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setAmount(float AMOUNT) {
        this.amount = AMOUNT;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setColor(int COLOR) {
        this.color = COLOR;
    }

    public int getColor() {
        return this.color;
    }

    public void setMonochrome(boolean MONOCHROME) {
        this.monochrome = MONOCHROME;
    }

    public boolean getMonochrome() {
        return this.monochrome;
    }

    public void setShine(float SHINE) {
        this.shine = SHINE;
    }

    public float getShine() {
        return this.shine;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage SOURCE, ColorModel dstCM) {
        if (dstCM == null) {
            dstCM = SOURCE.getColorModel();
        }
        return new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(SOURCE.getWidth(), SOURCE.getHeight()), dstCM.isAlphaPremultiplied(), null);
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage SOURCE) {
        return new Rectangle(0, 0, SOURCE.getWidth(), SOURCE.getHeight());
    }

    @Override
    public Point2D getPoint2D(Point2D SOURCE_POINT, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Double();
        }
        dstPt.setLocation(SOURCE_POINT.getX(), SOURCE_POINT.getY());
        return dstPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    public void setRGB(BufferedImage IMAGE, int X, int Y, int WIDTH, int HEIGHT, int[] PIXELS) {
        int type = IMAGE.getType();
        if (type == 2 || type == 1) {
            IMAGE.getRaster().setDataElements(X, Y, WIDTH, HEIGHT, PIXELS);
        } else {
            IMAGE.setRGB(X, Y, WIDTH, HEIGHT, PIXELS, 0, WIDTH);
        }
    }

    public String toString() {
        return "Texture/Brushed Metal...";
    }
}

