/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.IOException;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicBoolean;
import tel.schich.javacan.NetworkDevice;
import tel.schich.javacan.SocketCAN;
import tel.schich.javacan.option.CanSocketOption;
import tel.schich.javacan.platform.NativeChannel;
import tel.schich.javacan.platform.linux.LinuxNativeOperationException;
import tel.schich.javacan.platform.linux.UnixFileDescriptor;

public abstract class AbstractCanChannel
implements NativeChannel<UnixFileDescriptor> {
    private final int sock;
    private final UnixFileDescriptor fileDescriptor;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public AbstractCanChannel(int sock) {
        this.sock = sock;
        this.fileDescriptor = new UnixFileDescriptor(sock);
    }

    public abstract NetworkDevice getDevice();

    public abstract boolean isBound();

    protected int getSocket() {
        return this.sock;
    }

    @Override
    public UnixFileDescriptor getHandle() {
        return this.fileDescriptor;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        if (this.open.compareAndSet(true, false)) {
            SocketCAN.close(this.sock);
        }
    }

    public void configureBlocking(boolean block) throws IOException {
        try {
            SocketCAN.setBlockingMode(this.sock, block);
        }
        catch (LinuxNativeOperationException e) {
            throw AbstractCanChannel.checkForClosedChannel(e);
        }
    }

    public boolean isBlocking() throws IOException {
        try {
            return SocketCAN.getBlockingMode(this.sock) != 0;
        }
        catch (LinuxNativeOperationException e) {
            throw AbstractCanChannel.checkForClosedChannel(e);
        }
    }

    public <T> void setOption(SocketOption<T> option, T value) throws IOException {
        this.setOption(option, value, true);
    }

    public <T> void setOptionUnsafe(SocketOption<T> option, T value) throws IOException {
        this.setOption(option, value, false);
    }

    private <T> void setOption(SocketOption<T> option, T value, boolean validate) throws IOException {
        if (option instanceof CanSocketOption) {
            try {
                ((CanSocketOption)option).getHandler().set(this.getHandle(), value, validate);
            }
            catch (LinuxNativeOperationException e) {
                throw AbstractCanChannel.checkForClosedChannel(e);
            }
        } else {
            throw new IllegalArgumentException("option " + option.name() + " is not supported by CAN channels!");
        }
    }

    public <T> T getOption(SocketOption<T> option) throws IOException {
        if (option instanceof CanSocketOption) {
            try {
                return ((CanSocketOption)option).getHandler().get(this.getHandle());
            }
            catch (LinuxNativeOperationException e) {
                throw AbstractCanChannel.checkForClosedChannel(e);
            }
        }
        throw new IllegalArgumentException(option.name() + " is no support by CAN channels!");
    }

    protected long readSocket(ByteBuffer buffer) throws IOException {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("The buffer must be a direct buffer!");
        }
        try {
            int pos = buffer.position();
            int bytesRead = (int)SocketCAN.read(this.sock, buffer, pos, buffer.remaining());
            buffer.position(pos + bytesRead);
            return bytesRead;
        }
        catch (LinuxNativeOperationException e) {
            throw AbstractCanChannel.checkForClosedChannel(e);
        }
    }

    protected long writeSocket(ByteBuffer buffer) throws IOException {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("The buffer must be a direct buffer!");
        }
        try {
            int pos = buffer.position();
            int bytesWritten = (int)SocketCAN.write(this.sock, buffer, pos, buffer.remaining());
            buffer.position(pos + bytesWritten);
            return bytesWritten;
        }
        catch (LinuxNativeOperationException e) {
            throw AbstractCanChannel.checkForClosedChannel(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(device=" + this.getDevice() + ", handle=" + this.getHandle() + ")";
    }

    protected static IOException checkForClosedChannel(LinuxNativeOperationException orig) throws IOException {
        if (orig.isBadFD()) {
            ClosedChannelException ex = new ClosedChannelException();
            ex.addSuppressed(orig);
            throw ex;
        }
        throw orig;
    }
}

