/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.util.Objects;

public class CanFilter {
    public static final int INVERTED_BIT = 0x20000000;
    public static final CanFilter ANY = new CanFilter(0, 0);
    public static final CanFilter NONE = new CanFilter(0);
    public static final int BYTES = 8;
    public static final int EXACT = -1;
    private final int id;
    private final int mask;

    public CanFilter(int id) {
        this(id, -1);
    }

    public CanFilter(int id, int mask) {
        this.id = id;
        this.mask = mask & 0xDFFFFFFF;
    }

    public int getId() {
        return this.id;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean isInverted() {
        return (this.id & 0x20000000) > 0;
    }

    public boolean isExact() {
        return this.mask == -1;
    }

    public boolean matchId(int id) {
        return (this.id & this.mask) == (id & this.mask);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanFilter canFilter = (CanFilter)o;
        return this.id == canFilter.id && this.mask == canFilter.mask;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.mask);
    }

    public String toString() {
        return (this.isInverted() ? "~" : "") + String.format("CanFilter(id=%X, mask=%X)", this.id, this.mask);
    }
}

