/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.devexperts.logging.Logging;
import com.rusefi.io.HeartBeatListeners;
import com.rusefi.io.LinkManager;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Timer;

public class ConnectionWatchdog {
    private static final Logging log = Logging.getLogging(ConnectionWatchdog.class);
    private final Timer reconnectTimer;
    private static boolean isCreated;

    private ConnectionWatchdog(int timeoutMs, Runnable restartAction) {
        this.reconnectTimer = new Timer(timeoutMs, e -> {
            restartAction.run();
            this.onDataArrived();
        });
    }

    public static synchronized void init(LinkManager linkManager) {
        AtomicBoolean isRestartPending = new AtomicBoolean();
        if (isCreated) {
            return;
        }
        isCreated = true;
        new ConnectionWatchdog(5000, () -> {
            if (isRestartPending.compareAndSet(false, true)) {
                linkManager.execute(() -> {
                    log.info("ConnectionWatchdog.reconnectTimer restarting: 5000");
                    linkManager.restart();
                    isRestartPending.set(false);
                });
            } else {
                log.info("restart already pending...");
            }
        }).start();
    }

    void start() {
        HeartBeatListeners.INSTANCE.addListener(this::onDataArrived);
        this.onDataArrived();
    }

    private void onDataArrived() {
        this.reconnectTimer.restart();
    }
}

