/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol;

import com.devexperts.logging.Logging;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.util.HexBinary;
import etch.util.CircularByteBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class IncomingDataBuffer {
    private static final Logging log = Logging.getLogging(IncomingDataBuffer.class);
    private static final int BUFFER_SIZE = 32768;
    private final String loggingPrefix;
    private final CircularByteBuffer cbb = new CircularByteBuffer(32768);
    private final AbstractIoStream.StreamStats streamStats;

    public IncomingDataBuffer(String loggingPrefix, AbstractIoStream.StreamStats streamStats) {
        this.loggingPrefix = loggingPrefix;
        this.streamStats = Objects.requireNonNull(streamStats, "streamStats");
    }

    public byte[] getPacket(String msg) throws EOFException {
        return this.getPacket(5000, msg, System.currentTimeMillis());
    }

    public byte[] getPacket(int timeoutMs, String msg) throws EOFException {
        return this.getPacket(timeoutMs, msg, System.currentTimeMillis());
    }

    public byte[] getPacket(int timeoutMs, String msg, long start) throws EOFException {
        boolean isTimeout = this.waitForBytes(msg + " header", start, 2);
        if (isTimeout) {
            return null;
        }
        int packetSize = IoHelper.swap16(this.getShort());
        if (packetSize < 0) {
            return null;
        }
        isTimeout = this.waitForBytes(timeoutMs, this.loggingPrefix + msg + " body", start, packetSize + 4);
        if (isTimeout) {
            return null;
        }
        byte[] packet = new byte[packetSize];
        this.getData(packet);
        int packetCrc = IoHelper.swap32(this.getInt());
        int actualCrc = IoHelper.getCrc32(packet);
        if (actualCrc != packetCrc) {
            String errorMessage = String.format("CRC mismatch on recv packet for %s: got %x but expected %x", msg, actualCrc, packetCrc);
            System.out.println(errorMessage);
            log.warn(errorMessage);
            return null;
        }
        this.onPacketArrived();
        return packet;
    }

    public void onPacketArrived() {
        this.streamStats.onPacketArrived();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(byte[] freshData) {
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            if (this.cbb.size() - this.cbb.length() < freshData.length) {
                log.error("buffer overflow not expected");
                throw new IllegalStateException("buffer overflow not expected");
            }
            this.cbb.put(freshData);
            this.cbb.notifyAll();
        }
        if (log.debugEnabled()) {
            log.info(freshData.length + " byte(s) arrived, total " + this.cbb.length());
        }
    }

    public boolean waitForBytes(String loggingMessage, long startTimestamp, int count) {
        return this.waitForBytes(5000, loggingMessage, startTimestamp, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForBytes(int timeoutMs, String loggingMessage, long startTimestamp, int count) {
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            while (this.cbb.length() < count) {
                int timeout = (int)(startTimestamp + (long)timeoutMs - System.currentTimeMillis());
                if (timeout <= 0) {
                    log.info(loggingMessage + ": timeout " + timeoutMs + "ms. Got only " + this.cbb.length() + " byte(s) while expecting " + count);
                    return true;
                }
                try {
                    this.cbb.wait(timeout);
                }
                catch (InterruptedException e) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingCount() {
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            return this.cbb.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dropPending() {
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            int pending = this.cbb.length();
            if (pending > 0) {
                log.error("dropPending: Unexpected pending data: " + pending + " byte(s)");
                byte[] bytes = new byte[pending];
                this.cbb.get(bytes);
                log.error("DROPPED FROM BUFFER: " + HexBinary.printByteArray(bytes));
            }
            return pending;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getByte() throws EOFException {
        this.streamStats.onArrived(1);
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            return this.cbb.getByte();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getShort() throws EOFException {
        this.streamStats.onArrived(2);
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            int result = this.cbb.getShort();
            if (log.debugEnabled()) {
                log.info("Consumed short, " + this.cbb.length() + " remaining");
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt() throws EOFException {
        this.streamStats.onArrived(4);
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            int result = this.cbb.getInt();
            if (log.debugEnabled()) {
                log.info("Consumed int, " + this.cbb.length() + " remaining");
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData(byte[] packet) {
        CircularByteBuffer circularByteBuffer = this.cbb;
        synchronized (circularByteBuffer) {
            this.cbb.get(packet);
            if (log.debugEnabled()) {
                log.info(packet.length + " consumed, " + this.cbb.length() + " remaining");
            }
        }
        this.streamStats.onArrived(packet.length);
    }

    public byte readByte() throws IOException {
        return this.readByte(5000);
    }

    public byte readByte(int timeoutMs) throws IOException {
        boolean isTimeout = this.waitForBytes(timeoutMs, this.loggingPrefix + "readByte", System.currentTimeMillis(), 1);
        if (isTimeout) {
            throw new EOFException("Timeout in readByte " + timeoutMs);
        }
        return (byte)this.getByte();
    }

    public int readInt() throws EOFException {
        boolean isTimeout = this.waitForBytes(this.loggingPrefix + "readInt", System.currentTimeMillis(), 4);
        if (isTimeout) {
            throw new EOFException("Timeout in readInt ");
        }
        return IoHelper.swap32(this.getInt());
    }

    public short readShort() throws EOFException {
        boolean isTimeout = this.waitForBytes(this.loggingPrefix + "readShort", System.currentTimeMillis(), 2);
        if (isTimeout) {
            throw new EOFException("Timeout in readShort");
        }
        return (short)IoHelper.swap16(this.getShort());
    }

    public void read(byte[] packet) throws EOFException {
        boolean isTimeout = this.waitForBytes(this.loggingPrefix + "read", System.currentTimeMillis(), packet.length);
        if (isTimeout) {
            throw new EOFException("Timeout while waiting for " + packet.length + " byte(s)");
        }
        this.getData(packet);
    }

    static {
        log.configureDebugEnabled(false);
    }
}

