/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.util.TextUtils;

public class HttpResponseException
extends ClientProtocolException {
    private static final long serialVersionUID = -7186627969477257933L;
    private final int statusCode;
    private final String reasonPhrase;
    private final byte[] contentBytes;
    private final ContentType contentType;

    public HttpResponseException(int statusCode, String reasonPhrase) {
        this(statusCode, reasonPhrase, null, null);
    }

    public HttpResponseException(int statusCode, String reasonPhrase, byte[] contentBytes, ContentType contentType) {
        super(String.format("status code: %d" + (TextUtils.isBlank(reasonPhrase) ? "" : ", reason phrase: %s") + (contentBytes == null ? "" : ", content: %s"), statusCode, reasonPhrase, contentBytes == null || contentType == null || contentType.getCharset() == null ? null : new String(contentBytes, contentType.getCharset())));
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.contentBytes = contentBytes;
        this.contentType = contentType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public byte[] getContentBytes() {
        return this.contentBytes;
    }

    public ContentType getContentType() {
        return this.contentType;
    }
}

