/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan.platform;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Platform {
    private static final Logger LOGGER = LoggerFactory.getLogger(Platform.class);
    private static final String LIB_PREFIX = "/native";
    private static final String PATH_PROP_PREFIX = "javacan.native.";
    private static final String PATH_PROP_FS_PATH = ".path";
    private static final String PATH_PROP_CLASS_PATH = ".classpath";

    public static boolean isLinux() {
        return System.getProperty("os.name").equalsIgnoreCase("Linux");
    }

    public static OS getOS() {
        if (Platform.isLinux()) {
            return OS.LINUX;
        }
        return OS.UNKNOWN;
    }

    public static void loadNativeLibrary(String name, Class<?> base) {
        try {
            System.loadLibrary(name);
            LOGGER.trace("Loaded native library {} from library path", (Object)name);
        }
        catch (LinkageError e) {
            Platform.loadExplicitLibrary(name, base);
        }
    }

    private static void loadExplicitLibrary(String name, Class<?> base) {
        String explicitLibraryPath = System.getProperty(PATH_PROP_PREFIX + name.toLowerCase() + PATH_PROP_FS_PATH);
        if (explicitLibraryPath != null) {
            LOGGER.trace("Loading native library {} from {}", (Object)name, (Object)explicitLibraryPath);
            System.load(explicitLibraryPath);
            return;
        }
        String explicitLibraryClassPath = System.getProperty(PATH_PROP_PREFIX + name.toLowerCase() + PATH_PROP_CLASS_PATH);
        if (explicitLibraryClassPath != null) {
            LOGGER.trace("Loading native library {} from explicit classpath at {}", (Object)name, (Object)explicitLibraryClassPath);
            try {
                Path tempDirectory = Files.createTempDirectory(name + "-", new FileAttribute[0]);
                Path libPath = tempDirectory.resolve("lib" + name + ".so");
                Platform.loadFromClassPath(name, base, explicitLibraryClassPath, libPath);
                return;
            }
            catch (IOException e) {
                throw new LinkageError("Unable to load native library " + name + "!", e);
            }
        }
        String sourceLibPath = "/native/lib" + name + ".so";
        LOGGER.trace("Loading native library {} from {}", (Object)name, (Object)sourceLibPath);
        try {
            Path tempDirectory = Files.createTempDirectory(name + "-", new FileAttribute[0]);
            Path libPath = tempDirectory.resolve("lib" + name + ".so");
            Platform.loadFromClassPath(name, base, sourceLibPath, libPath);
        }
        catch (IOException e) {
            throw new LinkageError("Unable to load native library " + name + "!", e);
        }
    }

    private static void loadFromClassPath(String name, Class<?> base, String classPath, Path fsPath) throws IOException {
        try (InputStream libStream = base.getResourceAsStream(classPath);){
            if (libStream == null) {
                throw new LinkageError("Failed to load the native library " + name + ": " + classPath + " not found.");
            }
            Files.copy(libStream, fsPath, StandardCopyOption.REPLACE_EXISTING);
            System.load(fsPath.toString());
            fsPath.toFile().deleteOnExit();
        }
    }

    public static enum OS {
        LINUX,
        UNKNOWN;

    }
}

