/*
 * Decompiled with CFR 0.152.
 */
package com.macfaq.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class LittleEndianOutputStream
extends FilterOutputStream {
    protected int written;

    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        ++this.written;
    }

    @Override
    public synchronized void write(byte[] data, int offset, int length) throws IOException {
        this.out.write(data, offset, length);
        this.written += length;
    }

    public void writeBoolean(boolean b) throws IOException {
        if (b) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int b) throws IOException {
        this.out.write(b);
        ++this.written;
    }

    public void writeShort(int s) throws IOException {
        this.out.write(s & 0xFF);
        this.out.write(s >>> 8 & 0xFF);
        this.written += 2;
    }

    public void writeChar(int c) throws IOException {
        this.out.write(c & 0xFF);
        this.out.write(c >>> 8 & 0xFF);
        this.written += 2;
    }

    public void writeInt(int i) throws IOException {
        this.out.write(i & 0xFF);
        this.out.write(i >>> 8 & 0xFF);
        this.out.write(i >>> 16 & 0xFF);
        this.out.write(i >>> 24 & 0xFF);
        this.written += 4;
    }

    public void writeLong(long l) throws IOException {
        this.out.write((int)l & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 56) & 0xFF);
        this.written += 8;
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBytes(String s) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            this.out.write((byte)s.charAt(i));
        }
        this.written += length;
    }

    public void writeChars(String s) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            this.out.write(c & 0xFF);
            this.out.write(c >>> 8 & 0xFF);
        }
        this.written += length * 2;
    }

    public void writeUTF(String s) throws IOException {
        char c;
        int i;
        int numchars = s.length();
        int numbytes = 0;
        for (i = 0; i < numchars; ++i) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++numbytes;
                continue;
            }
            if (c > '\u07ff') {
                numbytes += 3;
                continue;
            }
            numbytes += 2;
        }
        if (numbytes > 65535) {
            throw new UTFDataFormatException();
        }
        this.out.write(numbytes >>> 8 & 0xFF);
        this.out.write(numbytes & 0xFF);
        for (i = 0; i < numchars; ++i) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.out.write(0xE0 | c >> 12 & 0xF);
                this.out.write(0x80 | c >> 6 & 0x3F);
                this.out.write(0x80 | c & 0x3F);
                this.written += 2;
                continue;
            }
            this.out.write(0xC0 | c >> 6 & 0x1F);
            this.out.write(0x80 | c & 0x3F);
            ++this.written;
        }
        this.written += numchars + 2;
    }

    public int size() {
        return this.written;
    }
}

