/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.config.FieldType;
import com.rusefi.io.UpdateOperationCallbacks;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

enum VeRpmBinsIniFieldMigrator {
    INSTANCE;

    private static final int VE_RPM_BINS_COLS = 1;
    private static final double VE_RPM_BINS_MULTIPLIER = 1.0;
    private static final String VE_RPM_BINS_DIGITS = "0";
    private static final FieldType VE_RPM_BINS_TYPE;

    /*
     * Enabled aggressive block sorting
     */
    Optional<String> tryMigrateVeRpmBins(IniField prevField, IniField newField, String prevValue, UpdateOperationCallbacks callbacks) {
        Optional<String> result = Optional.empty();
        Optional<ArrayIniField> prevVeRpmBinsValidatedField = VeRpmBinsIniFieldMigrator.getValidatedVeRpmBinsArrayIniField(prevField, callbacks);
        Optional<ArrayIniField> newVeRpmBinsValidatedField = VeRpmBinsIniFieldMigrator.getValidatedVeRpmBinsArrayIniField(newField, callbacks);
        if (!prevVeRpmBinsValidatedField.isPresent()) return result;
        if (!newVeRpmBinsValidatedField.isPresent()) return result;
        ArrayIniField prevVeRpmBinsField = prevVeRpmBinsValidatedField.get();
        ArrayIniField newVeRpmBinsField = newVeRpmBinsValidatedField.get();
        int prevVeRpmBinsFieldRows = prevVeRpmBinsField.getRows();
        int newVeRpmBinsFieldRows = newVeRpmBinsField.getRows();
        if (prevVeRpmBinsFieldRows == 16 && newVeRpmBinsFieldRows == 24) {
            List prevValues = Arrays.stream(prevVeRpmBinsField.getValues(prevValue)).map(e -> e[0]).collect(Collectors.toList());
            List<Long> prevLongValues = prevValues.stream().map(Double::parseDouble).map(Math::round).collect(Collectors.toList());
            long lastValue = (Long)prevLongValues.get(prevLongValues.size() - 1);
            String max = newVeRpmBinsField.getMax();
            Optional<Object> recommendedStep = Optional.empty();
            if (max != null) {
                long maxPossibleStep = (long)((Double.parseDouble(max) - (double)lastValue) / 8.0);
                if (1L > maxPossibleStep) {
                    callbacks.logLine(String.format("WARNING! `veRpmBins` ini-field cannot be propagated with increasing values, because max value is %s", max));
                    return Optional.empty();
                }
                recommendedStep = Optional.of(VeRpmBinsIniFieldMigrator.chooseStep(prevLongValues, maxPossibleStep));
            } else {
                long valueBeforeLast = (Long)prevLongValues.get(prevLongValues.size() - 2);
                recommendedStep = Optional.of(lastValue - valueBeforeLast);
            }
            if (!recommendedStep.isPresent()) return result;
            String[][] newValues = new String[24][1];
            for (int i = 0; i < 16; ++i) {
                newValues[i] = new String[]{(String)prevValues.get(i)};
            }
            long lastBin = lastValue;
            int i = 16;
            while (true) {
                if (i >= 24) {
                    return Optional.of(newVeRpmBinsField.formatValue(newValues));
                }
                newValues[i] = new String[]{String.format("%.1f", lastBin += ((Long)recommendedStep.get()).longValue())};
                ++i;
            }
        }
        callbacks.logLine("WARNING! We failed to extend `veRpmBins` ini-field");
        return result;
    }

    private static Optional<ArrayIniField> getValidatedVeRpmBinsArrayIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `veRpmBins` ini-field is expected to be `ArrayIniField` instead of %s", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != VE_RPM_BINS_TYPE) {
            callbacks.logLine(String.format("WARNING! Type of `veRpmBins` ini-field is expected to be `%s` instead of `%s`", new Object[]{VE_RPM_BINS_TYPE, arrayFieldType}));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        if (arrayFieldCols != 1) {
            callbacks.logLine(String.format("WARNING! `veRpmBins` ini-field is expected to contain %d columns instead of %d", 16, arrayFieldCols));
            return Optional.empty();
        }
        double arrayFieldMultiplier = arrayField.getMultiplier();
        if (arrayFieldMultiplier != 1.0) {
            callbacks.logLine(String.format("WARNING! Multiplier of `veRpmBins` ini-field is expected to be %f instead of %f", 1.0, arrayFieldMultiplier));
            return Optional.empty();
        }
        String arrayFieldDigits = arrayField.getDigits();
        if (!VE_RPM_BINS_DIGITS.equals(arrayFieldDigits)) {
            callbacks.logLine(String.format("WARNING! Digits of `veRpmBins` ini-field is expected to be `%s` instead of `%s`", VE_RPM_BINS_DIGITS, arrayFieldDigits));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        switch (arrayFieldRows) {
            case 16: 
            case 24: {
                return Optional.of(arrayField);
            }
        }
        callbacks.logLine(String.format("WARNING! `veRpmBins` ini-field is expected to contain %d or %d rows instead of %d", 16, 24, arrayFieldRows));
        return Optional.empty();
    }

    private static long chooseStep(List<Long> bins, long maxPossibleStep) {
        Long lastBin = null;
        Long lastStep = null;
        Long maxStep = null;
        for (long bin : bins) {
            if (lastBin != null && (lastStep = Long.valueOf(bin - lastBin)) <= maxPossibleStep && (maxStep == null || maxStep < lastStep)) {
                maxStep = lastStep;
            }
            lastBin = bin;
        }
        if (lastStep != null) {
            if (lastStep <= maxPossibleStep) {
                return lastStep;
            }
            if (maxStep != null) {
                return maxStep;
            }
        }
        return maxPossibleStep;
    }

    static {
        VE_RPM_BINS_TYPE = FieldType.UINT16;
    }
}

