/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.jobs.AsyncJob;
import com.rusefi.maintenance.jobs.AsyncJobExecutor;
import java.awt.Component;
import java.util.Optional;
import javax.swing.JOptionPane;

public class SingleAsyncJobExecutor {
    private final UpdateOperationCallbacks updateOperationCallbacks;
    private final boolean doNotUseStatusWindow;
    private volatile Optional<AsyncJob> jobInProgress = Optional.empty();

    SingleAsyncJobExecutor(UpdateOperationCallbacks updateOperationCallbacks, boolean doNotUseStatusWindow, Runnable onJobInProgressFinished) {
        this.updateOperationCallbacks = updateOperationCallbacks;
        this.doNotUseStatusWindow = doNotUseStatusWindow;
    }

    void startJob(AsyncJob job, Component parent) {
        Optional<AsyncJob> prevJobInProgress = this.setJobInProgressIfEmpty(job);
        if (!prevJobInProgress.isPresent()) {
            this.updateOperationCallbacks.clear();
            if (this.doNotUseStatusWindow) {
                AsyncJobExecutor.INSTANCE.executeJob(job, this.updateOperationCallbacks, this::handleJobInProgressFinished);
            } else {
                AsyncJobExecutor.INSTANCE.executeJobWithStatusWindow(job, this.updateOperationCallbacks, this::handleJobInProgressFinished);
            }
        } else {
            JOptionPane.showMessageDialog(parent, String.format("Job `%s` is already in progress!", prevJobInProgress.get().getName()), "Error", 0);
        }
    }

    public synchronized boolean isNotInProgress() {
        return !this.jobInProgress.isPresent();
    }

    private synchronized Optional<AsyncJob> setJobInProgressIfEmpty(AsyncJob job) {
        Optional<AsyncJob> prevJobInProgress = this.jobInProgress;
        if (!prevJobInProgress.isPresent()) {
            this.jobInProgress = Optional.of(job);
        }
        return prevJobInProgress;
    }

    private synchronized void resetJobInProgress() {
        this.jobInProgress = Optional.empty();
    }

    private void handleJobInProgressFinished() {
        this.resetJobInProgress();
    }
}

