/*
 * Decompiled with CFR 0.152.
 */
package com.camick;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class RXTextUtilities {
    public static void centerLineInScrollPane(JTextComponent component) {
        Container container = SwingUtilities.getAncestorOfClass(JViewport.class, component);
        if (container == null) {
            return;
        }
        try {
            Rectangle r = component.modelToView(component.getCaretPosition());
            JViewport viewport = (JViewport)container;
            int extentHeight = viewport.getExtentSize().height;
            int viewHeight = viewport.getViewSize().height;
            int y = Math.max(0, r.y - (extentHeight - r.height) / 2);
            y = Math.min(y, viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static int getColumnAtCaret(JTextComponent component) {
        FontMetrics fm = component.getFontMetrics(component.getFont());
        int characterWidth = fm.stringWidth("0");
        int column = 0;
        try {
            Rectangle r = component.modelToView(component.getCaretPosition());
            int width = r.x - component.getInsets().left;
            column = width / characterWidth;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return column + 1;
    }

    public static int getLineAtCaret(JTextComponent component) {
        int caretPosition = component.getCaretPosition();
        Element root = component.getDocument().getDefaultRootElement();
        return root.getElementIndex(caretPosition) + 1;
    }

    public static int getLines(JTextComponent component) {
        Element root = component.getDocument().getDefaultRootElement();
        return root.getElementCount();
    }

    public static void gotoStartOfLine(JTextComponent component, int line) {
        int startOfLineOffset = RXTextUtilities.getStartOfLineOffset(component, line);
        component.setCaretPosition(startOfLineOffset);
    }

    public static int getStartOfLineOffset(JTextComponent component, int line) {
        Element root = component.getDocument().getDefaultRootElement();
        line = Math.max(line, 1);
        line = Math.min(line, root.getElementCount());
        return root.getElement(line - 1).getStartOffset();
    }

    public static void gotoFirstWordOnLine(JTextComponent component, int line) {
        RXTextUtilities.gotoStartOfLine(component, line);
        try {
            int position = component.getCaretPosition();
            String first = component.getDocument().getText(position, 1);
            if (Character.isWhitespace(first.charAt(0))) {
                component.setCaretPosition(Utilities.getNextWord(component, position));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getWrappedLines(JTextArea component) {
        View view = component.getUI().getRootView(component).getView(0);
        int preferredHeight = (int)view.getPreferredSpan(1);
        int lineHeight = component.getFontMetrics(component.getFont()).getHeight();
        return preferredHeight / lineHeight;
    }

    public static int getWrappedLines(JTextComponent component) {
        int lines = 0;
        View view = component.getUI().getRootView(component).getView(0);
        int paragraphs = view.getViewCount();
        for (int i = 0; i < paragraphs; ++i) {
            lines += view.getView(i).getViewCount();
        }
        return lines;
    }
}

