/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.can;

import com.devexperts.logging.Logging;
import com.rusefi.io.can.SocketCANIoStream;
import com.rusefi.uds.CanConnector;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import tel.schich.javacan.CanChannels;
import tel.schich.javacan.CanFrame;
import tel.schich.javacan.CanSocketOptions;
import tel.schich.javacan.NetworkDevice;
import tel.schich.javacan.RawCanChannel;

public class SocketCANHelper {
    private static Logging log = Logging.getLogging(SocketCANIoStream.class);

    @NotNull
    public static RawCanChannel createSocket() {
        RawCanChannel socket;
        try {
            NetworkDevice canInterface = NetworkDevice.lookup(System.getProperty("CAN_DEVICE_NAME", "can0"));
            socket = CanChannels.newRawChannel();
            socket.bind(canInterface);
            socket.configureBlocking(true);
            socket.setOption(CanSocketOptions.RECV_OWN_MSGS, false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error looking up", e);
        }
        return socket;
    }

    public static void send(int id, byte[] payload, RawCanChannel channel) {
        CanFrame packet = CanFrame.create(id, (byte)0, payload);
        try {
            channel.write(packet);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static CanConnector.CanPacket read(RawCanChannel socket) throws IOException {
        final CanFrame rx = socket.read();
        if (log.debugEnabled()) {
            log.debug("GOT " + String.format("%X", rx));
        }
        final byte[] raw = new byte[rx.getDataLength()];
        rx.getData(raw, 0, raw.length);
        return new CanConnector.CanPacket(){

            @Override
            public int id() {
                return rx.getId();
            }

            @Override
            public byte[] payload() {
                return raw;
            }
        };
    }
}

