/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.extras.Poi;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public enum PoiUtil {
    INSTANCE;


    public double distanceTo(Poi P1, Poi P2) {
        return this.distanceTo(P1.getLon(), P1.getLat(), P2.getLon(), P2.getLat());
    }

    public double distanceTo(double LAT1, double LON1, double LAT2, double LON2) {
        double EARTH_RADIUS = 6371000.0;
        return Math.abs(Math.acos(Math.sin(Math.toRadians(LAT1)) * Math.sin(Math.toRadians(LAT2)) + Math.cos(Math.toRadians(LAT1)) * Math.cos(Math.toRadians(LAT2)) * Math.cos(Math.toRadians(LON1 - LON2))) * 6371000.0);
    }

    public Poi shiftTo(Poi POINT, double DISTANCE, double ANGLE) {
        double EARTH_RADIUS = 6371000.0;
        double LON1 = Math.toRadians(POINT.getLon());
        double LAT1 = Math.toRadians(POINT.getLat());
        double LAT2 = Math.asin(Math.sin(LAT1) * Math.cos(DISTANCE / 6371000.0) + Math.cos(LAT1) * Math.sin(DISTANCE / 6371000.0) * Math.cos(Math.toRadians(ANGLE)));
        double LON2 = LON1 + Math.atan2(Math.sin(Math.toRadians(ANGLE)) * Math.sin(DISTANCE / 6371000.0) * Math.cos(LAT1), Math.cos(DISTANCE / 6371000.0) - Math.sin(LAT1) * Math.sin(LAT2));
        double LON2_CORRECTED = (LON2 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new Poi(POINT.getName(), Math.toDegrees(LON2_CORRECTED), Math.toDegrees(LAT2));
    }

    public Poi shiftTo(String NAME, double LAT1, double LON1, double DISTANCE, double ANGLE) {
        return this.shiftTo(new Poi(NAME, LAT1, LON1), DISTANCE, ANGLE);
    }

    public Point2D toXY(double LAT, double LON, Rectangle MAP) {
        double LATITUDE = LAT * -1.0 + 90.0;
        double LONGITUDE = LON + 180.0;
        double X = Math.round(LONGITUDE * (MAP.getWidth() / 360.0));
        double Y = Math.round(LATITUDE * (MAP.getHeight() / 180.0));
        return new Point2D.Double(X, Y);
    }

    public Point2D toXY(Poi POINT, Rectangle MAP) {
        return this.toXY(POINT.getLat(), POINT.getLon(), MAP);
    }
}

