/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.IniField;
import com.rusefi.CompatibilitySet;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.IniFieldMigrationUtils;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.DefaultIniFieldMigrationStrategy;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public enum DefaultTuneMigrator implements TuneMigrator
{
    INSTANCE;

    private static final Logging log;
    private static final Set<String> INI_FIELDS_TO_IGNORE;
    private static final Set<String> boardSpecificIniFieldsToIgnore;

    @Override
    public void migrateTune(TuneMigrationContext context) {
        IniFileModel prevIni = context.getPrevIniFile();
        Map<String, IniField> prevIniFields = prevIni.getAllIniFields();
        for (Map.Entry<String, IniField> prevFieldEntry : prevIniFields.entrySet()) {
            DefaultTuneMigrator.migrateIniField(context, prevFieldEntry);
        }
    }

    private static void migrateIniField(TuneMigrationContext context, Map.Entry<String, IniField> prevFieldEntry) {
        String prevFieldName = prevFieldEntry.getKey();
        if (INI_FIELDS_TO_IGNORE.contains(prevFieldName) || boardSpecificIniFieldsToIgnore.contains(prevFieldName) || context.isAdditionalIniFieldToIgnore(prevFieldName) || DefaultTuneMigrator.isUnusedField(prevFieldName)) {
            return;
        }
        if (context.isFieldAlreadyMigrated(prevFieldName) || context.getMigratedConstants().containsKey(prevFieldEntry)) {
            return;
        }
        UpdateOperationCallbacks callbacks = context.getCallbacks();
        IniFileModel newIni = context.getUpdatedIniFile();
        Map<String, Constant> newValues = context.getUpdatedTune().getConstantsAsMap();
        Map<String, Constant> prevValues = context.getPrevTune().getConstantsAsMap();
        Map<String, IniField> newIniFields = newIni.getAllIniFields();
        IniField newField = newIniFields.get(prevFieldName);
        Constant prevValue = prevValues.get(prevFieldName);
        if (newField == null) {
            if (prevValue != null) {
                callbacks.logLine(String.format("We aren't going to restore field `%s`: it is missed in new .ini file", prevFieldName));
            }
            return;
        }
        if (prevValue == null) {
            return;
        }
        Constant newValue = newValues.get(prevFieldName);
        if (newValue == null) {
            log.info(String.format("Field `%s` is going to be restored: <none> -> `%s`", prevFieldName, prevValue.getValue()));
            context.addMigration(prevFieldName, prevValue);
            return;
        }
        if (Objects.equals(prevValue.getValue(), newValue.getValue())) {
            return;
        }
        if (!Objects.equals(prevValue.getName(), newValue.getName())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its name is updated: `%s` -> `%s`", prevFieldName, prevValue.getName(), newValue.getName()));
        } else if (!IniFieldMigrationUtils.checkIfUnitsCanBeMigrated(prevValue.getUnits(), newValue.getUnits())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its units are updated: `%s` -> `%s`", prevFieldName, prevValue.getUnits(), newValue.getUnits()));
        } else if (!IniFieldMigrationUtils.checkIfDigitsCanBeMigrated(prevValue.getDigits(), newValue.getDigits(), prevFieldName)) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its digits are updated: `%s` -> `%s`", prevFieldName, prevValue.getDigits(), newValue.getDigits()));
        } else if (!Objects.equals(prevValue.getCols(), newValue.getCols())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its column count is updated: `%s` -> `%s`", prevFieldName, prevValue.getCols(), newValue.getCols()));
        } else if (!Objects.equals(prevValue.getRows(), newValue.getRows())) {
            callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its row count is updated: `%s` -> `%s`", prevFieldName, prevValue.getRows(), newValue.getRows()));
        } else {
            Optional<String> migratedValue = DefaultIniFieldMigrationStrategy.INSTANCE.tryMigrateValue(prevFieldEntry.getValue(), newField, prevValue.getValue(), callbacks);
            if (migratedValue.isPresent()) {
                String valueToRestore = migratedValue.get();
                if (!valueToRestore.equals(newValue.getValue())) {
                    log.info(String.format("Field `%s` is going to be restored: `%s` -> `%s`", prevFieldName, newValue.getValue(), prevValue.getValue()));
                    context.addMigration(prevFieldName, newValue.cloneWithValue(valueToRestore));
                } else {
                    callbacks.logLine(String.format("We aren't going to restore field `%s`: it looks like its value is just renamed: `%s` -> `%s`", prevFieldName, prevValue.getValue(), newValue.getValue()));
                }
            } else {
                log.warn(String.format("Field `%s` cannot be updated: `%s` -> `%s`", prevFieldName, prevFieldEntry.getValue(), newField));
            }
        }
    }

    private static boolean isUnusedField(String fieldName) {
        return fieldName.startsWith("unused");
    }

    static {
        log = Logging.getLogging(DefaultTuneMigrator.class);
        INI_FIELDS_TO_IGNORE = CompatibilitySet.of("byFirmwareVersion");
        boardSpecificIniFieldsToIgnore = ConnectionAndMeta.getNonMigratableIniFields();
    }
}

