/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ts;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileModelImpl;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.ts.TsHelper;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public enum TsProjectUpdater {
    INSTANCE;

    private static final Logging log;

    public void afterTuneMigration(TuneMigrationContext context) {
        try {
            this.adjustTsProjectState(context);
        }
        catch (IOException e) {
            log.warn("Error updating TS project");
        }
    }

    private void adjustTsProjectState(TuneMigrationContext context) throws IOException {
        Properties properties = TsHelper.readTsProperties();
        String lastProjectPath = properties.getProperty("lastProjectPath");
        String lastConnectedFirmwareSignature = properties.getProperty("lastConnectedFirmwareSignature");
        if (lastProjectPath == null || lastConnectedFirmwareSignature == null) {
            log.warn("no lastProjectPath or lastConnectedFirmwareSignature");
            return;
        }
        log.info("lastProjectPath=" + lastProjectPath + ", lastConnectedFirmwareSignature=" + lastConnectedFirmwareSignature);
        String projectIniFile = lastProjectPath + File.separator + TsHelper.MAIN_CONTROLLER_PATH;
        IniFileModelImpl tsProjectIni = IniFileModelImpl.readIniFile(projectIniFile);
        String tsProjectSignature = tsProjectIni.getSignature();
        if (!tsProjectSignature.equals(context.getPrevIniFile().getSignature())) {
            log.info(tsProjectSignature + " does not match " + context.getPrevIniFile().getSignature());
            return;
        }
    }

    static {
        log = Logging.getLogging(TsProjectUpdater.class);
    }
}

